/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse;

public class ListFleetsForVehicleIterable
implements SdkIterable<ListFleetsForVehicleResponse> {
    private final IoTFleetWiseClient client;
    private final ListFleetsForVehicleRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFleetsForVehicleIterable(IoTFleetWiseClient client, ListFleetsForVehicleRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFleetsForVehicleResponseFetcher();
    }

    public Iterator<ListFleetsForVehicleResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> fleets() {
        Function<ListFleetsForVehicleResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleets() != null) {
                return response.fleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFleetsForVehicleResponseFetcher
    implements SyncPageFetcher<ListFleetsForVehicleResponse> {
        private ListFleetsForVehicleResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetsForVehicleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFleetsForVehicleResponse nextPage(ListFleetsForVehicleResponse previousPage) {
            if (previousPage == null) {
                return ListFleetsForVehicleIterable.this.client.listFleetsForVehicle(ListFleetsForVehicleIterable.this.firstRequest);
            }
            return ListFleetsForVehicleIterable.this.client.listFleetsForVehicle((ListFleetsForVehicleRequest)((Object)ListFleetsForVehicleIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

