/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the vehicle to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVehicleRequestItem implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateVehicleRequestItem.Builder, UpdateVehicleRequestItem> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vehicleName").getter(getter(UpdateVehicleRequestItem::vehicleName)).setter(setter(Builder::vehicleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()).build();

    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelManifestArn").getter(getter(UpdateVehicleRequestItem::modelManifestArn))
            .setter(setter(Builder::modelManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()).build();

    private static final SdkField<String> DECODER_MANIFEST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decoderManifestArn").getter(getter(UpdateVehicleRequestItem::decoderManifestArn))
            .setter(setter(Builder::decoderManifestArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decoderManifestArn").build())
            .build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(UpdateVehicleRequestItem::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ATTRIBUTE_UPDATE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeUpdateMode").getter(getter(UpdateVehicleRequestItem::attributeUpdateModeAsString))
            .setter(setter(Builder::attributeUpdateMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeUpdateMode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD,
            MODEL_MANIFEST_ARN_FIELD, DECODER_MANIFEST_ARN_FIELD, ATTRIBUTES_FIELD, ATTRIBUTE_UPDATE_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vehicleName;

    private final String modelManifestArn;

    private final String decoderManifestArn;

    private final Map<String, String> attributes;

    private final String attributeUpdateMode;

    private UpdateVehicleRequestItem(BuilderImpl builder) {
        this.vehicleName = builder.vehicleName;
        this.modelManifestArn = builder.modelManifestArn;
        this.decoderManifestArn = builder.decoderManifestArn;
        this.attributes = builder.attributes;
        this.attributeUpdateMode = builder.attributeUpdateMode;
    }

    /**
     * <p>
     * The unique ID of the vehicle to update.
     * </p>
     * 
     * @return The unique ID of the vehicle to update.
     */
    public final String vehicleName() {
        return vehicleName;
    }

    /**
     * <p>
     * The ARN of the vehicle model (model manifest) associated with the vehicle to update.
     * </p>
     * 
     * @return The ARN of the vehicle model (model manifest) associated with the vehicle to update.
     */
    public final String modelManifestArn() {
        return modelManifestArn;
    }

    /**
     * <p>
     * The ARN of the signal decoder manifest associated with the vehicle to update.
     * </p>
     * 
     * @return The ARN of the signal decoder manifest associated with the vehicle to update.
     */
    public final String decoderManifestArn() {
        return decoderManifestArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Static information about a vehicle in a key-value pair. For example:
     * </p>
     * <p>
     * <code>"engineType"</code> : <code>"1.3 L R2"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Static information about a vehicle in a key-value pair. For example:</p>
     *         <p>
     *         <code>"engineType"</code> : <code>"1.3 L R2"</code>
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The method the specified attributes will update the existing attributes on the vehicle. Use<code>Overwite</code>
     * to replace the vehicle attributes with the specified attributes. Or use <code>Merge</code> to combine all
     * attributes.
     * </p>
     * <p>
     * This is required if attributes are present in the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeUpdateMode} will return {@link UpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #attributeUpdateModeAsString}.
     * </p>
     * 
     * @return The method the specified attributes will update the existing attributes on the vehicle. Use
     *         <code>Overwite</code> to replace the vehicle attributes with the specified attributes. Or use
     *         <code>Merge</code> to combine all attributes.</p>
     *         <p>
     *         This is required if attributes are present in the input.
     * @see UpdateMode
     */
    public final UpdateMode attributeUpdateMode() {
        return UpdateMode.fromValue(attributeUpdateMode);
    }

    /**
     * <p>
     * The method the specified attributes will update the existing attributes on the vehicle. Use<code>Overwite</code>
     * to replace the vehicle attributes with the specified attributes. Or use <code>Merge</code> to combine all
     * attributes.
     * </p>
     * <p>
     * This is required if attributes are present in the input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeUpdateMode} will return {@link UpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #attributeUpdateModeAsString}.
     * </p>
     * 
     * @return The method the specified attributes will update the existing attributes on the vehicle. Use
     *         <code>Overwite</code> to replace the vehicle attributes with the specified attributes. Or use
     *         <code>Merge</code> to combine all attributes.</p>
     *         <p>
     *         This is required if attributes are present in the input.
     * @see UpdateMode
     */
    public final String attributeUpdateModeAsString() {
        return attributeUpdateMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(decoderManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeUpdateModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVehicleRequestItem)) {
            return false;
        }
        UpdateVehicleRequestItem other = (UpdateVehicleRequestItem) obj;
        return Objects.equals(vehicleName(), other.vehicleName()) && Objects.equals(modelManifestArn(), other.modelManifestArn())
                && Objects.equals(decoderManifestArn(), other.decoderManifestArn()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes())
                && Objects.equals(attributeUpdateModeAsString(), other.attributeUpdateModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVehicleRequestItem").add("VehicleName", vehicleName())
                .add("ModelManifestArn", modelManifestArn()).add("DecoderManifestArn", decoderManifestArn())
                .add("Attributes", hasAttributes() ? attributes() : null)
                .add("AttributeUpdateMode", attributeUpdateModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vehicleName":
            return Optional.ofNullable(clazz.cast(vehicleName()));
        case "modelManifestArn":
            return Optional.ofNullable(clazz.cast(modelManifestArn()));
        case "decoderManifestArn":
            return Optional.ofNullable(clazz.cast(decoderManifestArn()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "attributeUpdateMode":
            return Optional.ofNullable(clazz.cast(attributeUpdateModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVehicleRequestItem, T> g) {
        return obj -> g.apply((UpdateVehicleRequestItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateVehicleRequestItem> {
        /**
         * <p>
         * The unique ID of the vehicle to update.
         * </p>
         * 
         * @param vehicleName
         *        The unique ID of the vehicle to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vehicleName(String vehicleName);

        /**
         * <p>
         * The ARN of the vehicle model (model manifest) associated with the vehicle to update.
         * </p>
         * 
         * @param modelManifestArn
         *        The ARN of the vehicle model (model manifest) associated with the vehicle to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelManifestArn(String modelManifestArn);

        /**
         * <p>
         * The ARN of the signal decoder manifest associated with the vehicle to update.
         * </p>
         * 
         * @param decoderManifestArn
         *        The ARN of the signal decoder manifest associated with the vehicle to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decoderManifestArn(String decoderManifestArn);

        /**
         * <p>
         * Static information about a vehicle in a key-value pair. For example:
         * </p>
         * <p>
         * <code>"engineType"</code> : <code>"1.3 L R2"</code>
         * </p>
         * 
         * @param attributes
         *        Static information about a vehicle in a key-value pair. For example:</p>
         *        <p>
         *        <code>"engineType"</code> : <code>"1.3 L R2"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The method the specified attributes will update the existing attributes on the vehicle. Use
         * <code>Overwite</code> to replace the vehicle attributes with the specified attributes. Or use
         * <code>Merge</code> to combine all attributes.
         * </p>
         * <p>
         * This is required if attributes are present in the input.
         * </p>
         * 
         * @param attributeUpdateMode
         *        The method the specified attributes will update the existing attributes on the vehicle. Use
         *        <code>Overwite</code> to replace the vehicle attributes with the specified attributes. Or use
         *        <code>Merge</code> to combine all attributes.</p>
         *        <p>
         *        This is required if attributes are present in the input.
         * @see UpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateMode
         */
        Builder attributeUpdateMode(String attributeUpdateMode);

        /**
         * <p>
         * The method the specified attributes will update the existing attributes on the vehicle. Use
         * <code>Overwite</code> to replace the vehicle attributes with the specified attributes. Or use
         * <code>Merge</code> to combine all attributes.
         * </p>
         * <p>
         * This is required if attributes are present in the input.
         * </p>
         * 
         * @param attributeUpdateMode
         *        The method the specified attributes will update the existing attributes on the vehicle. Use
         *        <code>Overwite</code> to replace the vehicle attributes with the specified attributes. Or use
         *        <code>Merge</code> to combine all attributes.</p>
         *        <p>
         *        This is required if attributes are present in the input.
         * @see UpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateMode
         */
        Builder attributeUpdateMode(UpdateMode attributeUpdateMode);
    }

    static final class BuilderImpl implements Builder {
        private String vehicleName;

        private String modelManifestArn;

        private String decoderManifestArn;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String attributeUpdateMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVehicleRequestItem model) {
            vehicleName(model.vehicleName);
            modelManifestArn(model.modelManifestArn);
            decoderManifestArn(model.decoderManifestArn);
            attributes(model.attributes);
            attributeUpdateMode(model.attributeUpdateMode);
        }

        public final String getVehicleName() {
            return vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getModelManifestArn() {
            return modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getDecoderManifestArn() {
            return decoderManifestArn;
        }

        public final void setDecoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
        }

        @Override
        public final Builder decoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
            return this;
        }

        public final String getAttributeUpdateMode() {
            return attributeUpdateMode;
        }

        public final void setAttributeUpdateMode(String attributeUpdateMode) {
            this.attributeUpdateMode = attributeUpdateMode;
        }

        @Override
        public final Builder attributeUpdateMode(String attributeUpdateMode) {
            this.attributeUpdateMode = attributeUpdateMode;
            return this;
        }

        @Override
        public final Builder attributeUpdateMode(UpdateMode attributeUpdateMode) {
            this.attributeUpdateMode(attributeUpdateMode == null ? null : attributeUpdateMode.toString());
            return this;
        }

        @Override
        public UpdateVehicleRequestItem build() {
            return new UpdateVehicleRequestItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
