/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.SignalCatalogSummary;

public class ListSignalCatalogsPublisher
implements SdkPublisher<ListSignalCatalogsResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListSignalCatalogsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSignalCatalogsPublisher(IoTFleetWiseAsyncClient client, ListSignalCatalogsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSignalCatalogsPublisher(IoTFleetWiseAsyncClient client, ListSignalCatalogsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSignalCatalogsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSignalCatalogsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SignalCatalogSummary> summaries() {
        Function<ListSignalCatalogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSignalCatalogsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSignalCatalogsResponseFetcher
    implements AsyncPageFetcher<ListSignalCatalogsResponse> {
        private ListSignalCatalogsResponseFetcher() {
        }

        public boolean hasNextPage(ListSignalCatalogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSignalCatalogsResponse> nextPage(ListSignalCatalogsResponse previousPage) {
            if (previousPage == null) {
                return ListSignalCatalogsPublisher.this.client.listSignalCatalogs(ListSignalCatalogsPublisher.this.firstRequest);
            }
            return ListSignalCatalogsPublisher.this.client.listSignalCatalogs((ListSignalCatalogsRequest)((Object)ListSignalCatalogsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

