/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.SignalCatalogSummary;

public class ListSignalCatalogsIterable
implements SdkIterable<ListSignalCatalogsResponse> {
    private final IoTFleetWiseClient client;
    private final ListSignalCatalogsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSignalCatalogsIterable(IoTFleetWiseClient client, ListSignalCatalogsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSignalCatalogsResponseFetcher();
    }

    public Iterator<ListSignalCatalogsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SignalCatalogSummary> summaries() {
        Function<ListSignalCatalogsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSignalCatalogsResponseFetcher
    implements SyncPageFetcher<ListSignalCatalogsResponse> {
        private ListSignalCatalogsResponseFetcher() {
        }

        public boolean hasNextPage(ListSignalCatalogsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSignalCatalogsResponse nextPage(ListSignalCatalogsResponse previousPage) {
            if (previousPage == null) {
                return ListSignalCatalogsIterable.this.client.listSignalCatalogs(ListSignalCatalogsIterable.this.firstRequest);
            }
            return ListSignalCatalogsIterable.this.client.listSignalCatalogs((ListSignalCatalogsRequest)((Object)ListSignalCatalogsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

