/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder;

public class ListDecoderManifestSignalsPublisher
implements SdkPublisher<ListDecoderManifestSignalsResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListDecoderManifestSignalsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDecoderManifestSignalsPublisher(IoTFleetWiseAsyncClient client, ListDecoderManifestSignalsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDecoderManifestSignalsPublisher(IoTFleetWiseAsyncClient client, ListDecoderManifestSignalsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDecoderManifestSignalsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDecoderManifestSignalsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SignalDecoder> signalDecoders() {
        Function<ListDecoderManifestSignalsResponse, Iterator> getIterator = response -> {
            if (response != null && response.signalDecoders() != null) {
                return response.signalDecoders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDecoderManifestSignalsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDecoderManifestSignalsResponseFetcher
    implements AsyncPageFetcher<ListDecoderManifestSignalsResponse> {
        private ListDecoderManifestSignalsResponseFetcher() {
        }

        public boolean hasNextPage(ListDecoderManifestSignalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDecoderManifestSignalsResponse> nextPage(ListDecoderManifestSignalsResponse previousPage) {
            if (previousPage == null) {
                return ListDecoderManifestSignalsPublisher.this.client.listDecoderManifestSignals(ListDecoderManifestSignalsPublisher.this.firstRequest);
            }
            return ListDecoderManifestSignalsPublisher.this.client.listDecoderManifestSignals((ListDecoderManifestSignalsRequest)((Object)ListDecoderManifestSignalsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

