/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataRequest;
import software.amazon.awssdk.services.ioteventsdata.model.UpdateDetectorRequest;
import software.amazon.awssdk.services.ioteventsdata.model.UpdateDetectorRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateDetectorRequest
extends IotEventsDataRequest
implements ToCopyableBuilder<Builder, BatchUpdateDetectorRequest> {
    private static final SdkField<List<UpdateDetectorRequest>> DETECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BatchUpdateDetectorRequest.getter(BatchUpdateDetectorRequest::detectors)).setter(BatchUpdateDetectorRequest.setter(Builder::detectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateDetectorRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTORS_FIELD));
    private final List<UpdateDetectorRequest> detectors;

    private BatchUpdateDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.detectors = builder.detectors;
    }

    public List<UpdateDetectorRequest> detectors() {
        return this.detectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDetectorRequest)) {
            return false;
        }
        BatchUpdateDetectorRequest other = (BatchUpdateDetectorRequest)((Object)obj);
        return Objects.equals(this.detectors(), other.detectors());
    }

    public String toString() {
        return ToString.builder((String)"BatchUpdateDetectorRequest").add("Detectors", this.detectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectors": {
                return Optional.ofNullable(clazz.cast(this.detectors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDetectorRequest, T> g) {
        return obj -> g.apply((BatchUpdateDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsDataRequest.BuilderImpl
    implements Builder {
        private List<UpdateDetectorRequest> detectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDetectorRequest model) {
            super(model);
            this.detectors(model.detectors);
        }

        public final Collection<UpdateDetectorRequest.Builder> getDetectors() {
            return this.detectors != null ? (Collection)this.detectors.stream().map(UpdateDetectorRequest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detectors(Collection<UpdateDetectorRequest> detectors) {
            this.detectors = UpdateDetectorRequestsCopier.copy(detectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(UpdateDetectorRequest ... detectors) {
            this.detectors(Arrays.asList(detectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(Consumer<UpdateDetectorRequest.Builder> ... detectors) {
            this.detectors(Stream.of(detectors).map(c -> (UpdateDetectorRequest)((UpdateDetectorRequest.Builder)UpdateDetectorRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetectors(Collection<UpdateDetectorRequest.BuilderImpl> detectors) {
            this.detectors = UpdateDetectorRequestsCopier.copyFromBuilder(detectors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateDetectorRequest build() {
            return new BatchUpdateDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateDetectorRequest> {
        public Builder detectors(Collection<UpdateDetectorRequest> var1);

        public Builder detectors(UpdateDetectorRequest ... var1);

        public Builder detectors(Consumer<UpdateDetectorRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

