/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.AcknowledgeActionConfiguration;
import software.amazon.awssdk.services.ioteventsdata.model.CustomerActionName;
import software.amazon.awssdk.services.ioteventsdata.model.DisableActionConfiguration;
import software.amazon.awssdk.services.ioteventsdata.model.EnableActionConfiguration;
import software.amazon.awssdk.services.ioteventsdata.model.ResetActionConfiguration;
import software.amazon.awssdk.services.ioteventsdata.model.SnoozeActionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerAction> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(CustomerAction.getter(CustomerAction::actionNameAsString)).setter(CustomerAction.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<SnoozeActionConfiguration> SNOOZE_ACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("snoozeActionConfiguration").getter(CustomerAction.getter(CustomerAction::snoozeActionConfiguration)).setter(CustomerAction.setter(Builder::snoozeActionConfiguration)).constructor(SnoozeActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snoozeActionConfiguration").build()}).build();
    private static final SdkField<EnableActionConfiguration> ENABLE_ACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("enableActionConfiguration").getter(CustomerAction.getter(CustomerAction::enableActionConfiguration)).setter(CustomerAction.setter(Builder::enableActionConfiguration)).constructor(EnableActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableActionConfiguration").build()}).build();
    private static final SdkField<DisableActionConfiguration> DISABLE_ACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("disableActionConfiguration").getter(CustomerAction.getter(CustomerAction::disableActionConfiguration)).setter(CustomerAction.setter(Builder::disableActionConfiguration)).constructor(DisableActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableActionConfiguration").build()}).build();
    private static final SdkField<AcknowledgeActionConfiguration> ACKNOWLEDGE_ACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acknowledgeActionConfiguration").getter(CustomerAction.getter(CustomerAction::acknowledgeActionConfiguration)).setter(CustomerAction.setter(Builder::acknowledgeActionConfiguration)).constructor(AcknowledgeActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acknowledgeActionConfiguration").build()}).build();
    private static final SdkField<ResetActionConfiguration> RESET_ACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resetActionConfiguration").getter(CustomerAction.getter(CustomerAction::resetActionConfiguration)).setter(CustomerAction.setter(Builder::resetActionConfiguration)).constructor(ResetActionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resetActionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD, SNOOZE_ACTION_CONFIGURATION_FIELD, ENABLE_ACTION_CONFIGURATION_FIELD, DISABLE_ACTION_CONFIGURATION_FIELD, ACKNOWLEDGE_ACTION_CONFIGURATION_FIELD, RESET_ACTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomerAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String actionName;
    private final SnoozeActionConfiguration snoozeActionConfiguration;
    private final EnableActionConfiguration enableActionConfiguration;
    private final DisableActionConfiguration disableActionConfiguration;
    private final AcknowledgeActionConfiguration acknowledgeActionConfiguration;
    private final ResetActionConfiguration resetActionConfiguration;

    private CustomerAction(BuilderImpl builder) {
        this.actionName = builder.actionName;
        this.snoozeActionConfiguration = builder.snoozeActionConfiguration;
        this.enableActionConfiguration = builder.enableActionConfiguration;
        this.disableActionConfiguration = builder.disableActionConfiguration;
        this.acknowledgeActionConfiguration = builder.acknowledgeActionConfiguration;
        this.resetActionConfiguration = builder.resetActionConfiguration;
    }

    public final CustomerActionName actionName() {
        return CustomerActionName.fromValue(this.actionName);
    }

    public final String actionNameAsString() {
        return this.actionName;
    }

    public final SnoozeActionConfiguration snoozeActionConfiguration() {
        return this.snoozeActionConfiguration;
    }

    public final EnableActionConfiguration enableActionConfiguration() {
        return this.enableActionConfiguration;
    }

    public final DisableActionConfiguration disableActionConfiguration() {
        return this.disableActionConfiguration;
    }

    public final AcknowledgeActionConfiguration acknowledgeActionConfiguration() {
        return this.acknowledgeActionConfiguration;
    }

    public final ResetActionConfiguration resetActionConfiguration() {
        return this.resetActionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snoozeActionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableActionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableActionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgeActionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetActionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerAction)) {
            return false;
        }
        CustomerAction other = (CustomerAction)obj;
        return Objects.equals(this.actionNameAsString(), other.actionNameAsString()) && Objects.equals(this.snoozeActionConfiguration(), other.snoozeActionConfiguration()) && Objects.equals(this.enableActionConfiguration(), other.enableActionConfiguration()) && Objects.equals(this.disableActionConfiguration(), other.disableActionConfiguration()) && Objects.equals(this.acknowledgeActionConfiguration(), other.acknowledgeActionConfiguration()) && Objects.equals(this.resetActionConfiguration(), other.resetActionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerAction").add("ActionName", (Object)this.actionNameAsString()).add("SnoozeActionConfiguration", (Object)this.snoozeActionConfiguration()).add("EnableActionConfiguration", (Object)this.enableActionConfiguration()).add("DisableActionConfiguration", (Object)this.disableActionConfiguration()).add("AcknowledgeActionConfiguration", (Object)this.acknowledgeActionConfiguration()).add("ResetActionConfiguration", (Object)this.resetActionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionNameAsString()));
            }
            case "snoozeActionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snoozeActionConfiguration()));
            }
            case "enableActionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.enableActionConfiguration()));
            }
            case "disableActionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.disableActionConfiguration()));
            }
            case "acknowledgeActionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.acknowledgeActionConfiguration()));
            }
            case "resetActionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resetActionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionName", ACTION_NAME_FIELD);
        map.put("snoozeActionConfiguration", SNOOZE_ACTION_CONFIGURATION_FIELD);
        map.put("enableActionConfiguration", ENABLE_ACTION_CONFIGURATION_FIELD);
        map.put("disableActionConfiguration", DISABLE_ACTION_CONFIGURATION_FIELD);
        map.put("acknowledgeActionConfiguration", ACKNOWLEDGE_ACTION_CONFIGURATION_FIELD);
        map.put("resetActionConfiguration", RESET_ACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerAction, T> g) {
        return obj -> g.apply((CustomerAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionName;
        private SnoozeActionConfiguration snoozeActionConfiguration;
        private EnableActionConfiguration enableActionConfiguration;
        private DisableActionConfiguration disableActionConfiguration;
        private AcknowledgeActionConfiguration acknowledgeActionConfiguration;
        private ResetActionConfiguration resetActionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerAction model) {
            this.actionName(model.actionName);
            this.snoozeActionConfiguration(model.snoozeActionConfiguration);
            this.enableActionConfiguration(model.enableActionConfiguration);
            this.disableActionConfiguration(model.disableActionConfiguration);
            this.acknowledgeActionConfiguration(model.acknowledgeActionConfiguration);
            this.resetActionConfiguration(model.resetActionConfiguration);
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        @Override
        public final Builder actionName(CustomerActionName actionName) {
            this.actionName(actionName == null ? null : actionName.toString());
            return this;
        }

        public final SnoozeActionConfiguration.Builder getSnoozeActionConfiguration() {
            return this.snoozeActionConfiguration != null ? this.snoozeActionConfiguration.toBuilder() : null;
        }

        public final void setSnoozeActionConfiguration(SnoozeActionConfiguration.BuilderImpl snoozeActionConfiguration) {
            this.snoozeActionConfiguration = snoozeActionConfiguration != null ? snoozeActionConfiguration.build() : null;
        }

        @Override
        public final Builder snoozeActionConfiguration(SnoozeActionConfiguration snoozeActionConfiguration) {
            this.snoozeActionConfiguration = snoozeActionConfiguration;
            return this;
        }

        public final EnableActionConfiguration.Builder getEnableActionConfiguration() {
            return this.enableActionConfiguration != null ? this.enableActionConfiguration.toBuilder() : null;
        }

        public final void setEnableActionConfiguration(EnableActionConfiguration.BuilderImpl enableActionConfiguration) {
            this.enableActionConfiguration = enableActionConfiguration != null ? enableActionConfiguration.build() : null;
        }

        @Override
        public final Builder enableActionConfiguration(EnableActionConfiguration enableActionConfiguration) {
            this.enableActionConfiguration = enableActionConfiguration;
            return this;
        }

        public final DisableActionConfiguration.Builder getDisableActionConfiguration() {
            return this.disableActionConfiguration != null ? this.disableActionConfiguration.toBuilder() : null;
        }

        public final void setDisableActionConfiguration(DisableActionConfiguration.BuilderImpl disableActionConfiguration) {
            this.disableActionConfiguration = disableActionConfiguration != null ? disableActionConfiguration.build() : null;
        }

        @Override
        public final Builder disableActionConfiguration(DisableActionConfiguration disableActionConfiguration) {
            this.disableActionConfiguration = disableActionConfiguration;
            return this;
        }

        public final AcknowledgeActionConfiguration.Builder getAcknowledgeActionConfiguration() {
            return this.acknowledgeActionConfiguration != null ? this.acknowledgeActionConfiguration.toBuilder() : null;
        }

        public final void setAcknowledgeActionConfiguration(AcknowledgeActionConfiguration.BuilderImpl acknowledgeActionConfiguration) {
            this.acknowledgeActionConfiguration = acknowledgeActionConfiguration != null ? acknowledgeActionConfiguration.build() : null;
        }

        @Override
        public final Builder acknowledgeActionConfiguration(AcknowledgeActionConfiguration acknowledgeActionConfiguration) {
            this.acknowledgeActionConfiguration = acknowledgeActionConfiguration;
            return this;
        }

        public final ResetActionConfiguration.Builder getResetActionConfiguration() {
            return this.resetActionConfiguration != null ? this.resetActionConfiguration.toBuilder() : null;
        }

        public final void setResetActionConfiguration(ResetActionConfiguration.BuilderImpl resetActionConfiguration) {
            this.resetActionConfiguration = resetActionConfiguration != null ? resetActionConfiguration.build() : null;
        }

        @Override
        public final Builder resetActionConfiguration(ResetActionConfiguration resetActionConfiguration) {
            this.resetActionConfiguration = resetActionConfiguration;
            return this;
        }

        public CustomerAction build() {
            return new CustomerAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerAction> {
        public Builder actionName(String var1);

        public Builder actionName(CustomerActionName var1);

        public Builder snoozeActionConfiguration(SnoozeActionConfiguration var1);

        default public Builder snoozeActionConfiguration(Consumer<SnoozeActionConfiguration.Builder> snoozeActionConfiguration) {
            return this.snoozeActionConfiguration((SnoozeActionConfiguration)((SnoozeActionConfiguration.Builder)SnoozeActionConfiguration.builder().applyMutation(snoozeActionConfiguration)).build());
        }

        public Builder enableActionConfiguration(EnableActionConfiguration var1);

        default public Builder enableActionConfiguration(Consumer<EnableActionConfiguration.Builder> enableActionConfiguration) {
            return this.enableActionConfiguration((EnableActionConfiguration)((EnableActionConfiguration.Builder)EnableActionConfiguration.builder().applyMutation(enableActionConfiguration)).build());
        }

        public Builder disableActionConfiguration(DisableActionConfiguration var1);

        default public Builder disableActionConfiguration(Consumer<DisableActionConfiguration.Builder> disableActionConfiguration) {
            return this.disableActionConfiguration((DisableActionConfiguration)((DisableActionConfiguration.Builder)DisableActionConfiguration.builder().applyMutation(disableActionConfiguration)).build());
        }

        public Builder acknowledgeActionConfiguration(AcknowledgeActionConfiguration var1);

        default public Builder acknowledgeActionConfiguration(Consumer<AcknowledgeActionConfiguration.Builder> acknowledgeActionConfiguration) {
            return this.acknowledgeActionConfiguration((AcknowledgeActionConfiguration)((AcknowledgeActionConfiguration.Builder)AcknowledgeActionConfiguration.builder().applyMutation(acknowledgeActionConfiguration)).build());
        }

        public Builder resetActionConfiguration(ResetActionConfiguration var1);

        default public Builder resetActionConfiguration(Consumer<ResetActionConfiguration.Builder> resetActionConfiguration) {
            return this.resetActionConfiguration((ResetActionConfiguration)((ResetActionConfiguration.Builder)ResetActionConfiguration.builder().applyMutation(resetActionConfiguration)).build());
        }
    }
}

