/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ioteventsdata.model.TimerDefinition;
import software.amazon.awssdk.services.ioteventsdata.model.TimerDefinitionsCopier;
import software.amazon.awssdk.services.ioteventsdata.model.VariableDefinition;
import software.amazon.awssdk.services.ioteventsdata.model.VariableDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorStateDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorStateDefinition> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectorStateDefinition.getter(DetectorStateDefinition::stateName)).setter(DetectorStateDefinition.setter(Builder::stateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()}).build();
    private static final SdkField<List<VariableDefinition>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectorStateDefinition.getter(DetectorStateDefinition::variables)).setter(DetectorStateDefinition.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariableDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TimerDefinition>> TIMERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectorStateDefinition.getter(DetectorStateDefinition::timers)).setter(DetectorStateDefinition.setter(Builder::timers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimerDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD, VARIABLES_FIELD, TIMERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stateName;
    private final List<VariableDefinition> variables;
    private final List<TimerDefinition> timers;

    private DetectorStateDefinition(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.variables = builder.variables;
        this.timers = builder.timers;
    }

    public String stateName() {
        return this.stateName;
    }

    public boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public List<VariableDefinition> variables() {
        return this.variables;
    }

    public boolean hasTimers() {
        return this.timers != null && !(this.timers instanceof SdkAutoConstructList);
    }

    public List<TimerDefinition> timers() {
        return this.timers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        hashCode = 31 * hashCode + Objects.hashCode(this.timers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorStateDefinition)) {
            return false;
        }
        DetectorStateDefinition other = (DetectorStateDefinition)obj;
        return Objects.equals(this.stateName(), other.stateName()) && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.timers(), other.timers());
    }

    public String toString() {
        return ToString.builder((String)"DetectorStateDefinition").add("StateName", (Object)this.stateName()).add("Variables", this.variables()).add("Timers", this.timers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateName": {
                return Optional.ofNullable(clazz.cast(this.stateName()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "timers": {
                return Optional.ofNullable(clazz.cast(this.timers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorStateDefinition, T> g) {
        return obj -> g.apply((DetectorStateDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stateName;
        private List<VariableDefinition> variables = DefaultSdkAutoConstructList.getInstance();
        private List<TimerDefinition> timers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorStateDefinition model) {
            this.stateName(model.stateName);
            this.variables(model.variables);
            this.timers(model.timers);
        }

        public final String getStateName() {
            return this.stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        public final Collection<VariableDefinition.Builder> getVariables() {
            return this.variables != null ? (Collection)this.variables.stream().map(VariableDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder variables(Collection<VariableDefinition> variables) {
            this.variables = VariableDefinitionsCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(VariableDefinition ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<VariableDefinition.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (VariableDefinition)((VariableDefinition.Builder)VariableDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVariables(Collection<VariableDefinition.BuilderImpl> variables) {
            this.variables = VariableDefinitionsCopier.copyFromBuilder(variables);
        }

        public final Collection<TimerDefinition.Builder> getTimers() {
            return this.timers != null ? (Collection)this.timers.stream().map(TimerDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder timers(Collection<TimerDefinition> timers) {
            this.timers = TimerDefinitionsCopier.copy(timers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(TimerDefinition ... timers) {
            this.timers(Arrays.asList(timers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(Consumer<TimerDefinition.Builder> ... timers) {
            this.timers(Stream.of(timers).map(c -> (TimerDefinition)((TimerDefinition.Builder)TimerDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTimers(Collection<TimerDefinition.BuilderImpl> timers) {
            this.timers = TimerDefinitionsCopier.copyFromBuilder(timers);
        }

        public DetectorStateDefinition build() {
            return new DetectorStateDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorStateDefinition> {
        public Builder stateName(String var1);

        public Builder variables(Collection<VariableDefinition> var1);

        public Builder variables(VariableDefinition ... var1);

        public Builder variables(Consumer<VariableDefinition.Builder> ... var1);

        public Builder timers(Collection<TimerDefinition> var1);

        public Builder timers(TimerDefinition ... var1);

        public Builder timers(Consumer<TimerDefinition.Builder> ... var1);
    }
}

