/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.DetectorDebugOption;
import software.amazon.awssdk.services.iotevents.model.DetectorDebugOptionsCopier;
import software.amazon.awssdk.services.iotevents.model.LoggingLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingOptions> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LoggingOptions.getter(LoggingOptions::roleArn)).setter(LoggingOptions.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LoggingOptions.getter(LoggingOptions::levelAsString)).setter(LoggingOptions.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LoggingOptions.getter(LoggingOptions::enabled)).setter(LoggingOptions.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<List<DetectorDebugOption>> DETECTOR_DEBUG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LoggingOptions.getter(LoggingOptions::detectorDebugOptions)).setter(LoggingOptions.setter(Builder::detectorDebugOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorDebugOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetectorDebugOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, LEVEL_FIELD, ENABLED_FIELD, DETECTOR_DEBUG_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String level;
    private final Boolean enabled;
    private final List<DetectorDebugOption> detectorDebugOptions;

    private LoggingOptions(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.level = builder.level;
        this.enabled = builder.enabled;
        this.detectorDebugOptions = builder.detectorDebugOptions;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public LoggingLevel level() {
        return LoggingLevel.fromValue(this.level);
    }

    public String levelAsString() {
        return this.level;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<DetectorDebugOption> detectorDebugOptions() {
        return this.detectorDebugOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorDebugOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingOptions)) {
            return false;
        }
        LoggingOptions other = (LoggingOptions)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.detectorDebugOptions(), other.detectorDebugOptions());
    }

    public String toString() {
        return ToString.builder((String)"LoggingOptions").add("RoleArn", (Object)this.roleArn()).add("Level", (Object)this.levelAsString()).add("Enabled", (Object)this.enabled()).add("DetectorDebugOptions", this.detectorDebugOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "detectorDebugOptions": {
                return Optional.ofNullable(clazz.cast(this.detectorDebugOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingOptions, T> g) {
        return obj -> g.apply((LoggingOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String level;
        private Boolean enabled;
        private List<DetectorDebugOption> detectorDebugOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingOptions model) {
            this.roleArn(model.roleArn);
            this.level(model.level);
            this.enabled(model.enabled);
            this.detectorDebugOptions(model.detectorDebugOptions);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLevelAsString() {
            return this.level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LoggingLevel level) {
            this.level(level.toString());
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<DetectorDebugOption.Builder> getDetectorDebugOptions() {
            return this.detectorDebugOptions != null ? (Collection)this.detectorDebugOptions.stream().map(DetectorDebugOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detectorDebugOptions(Collection<DetectorDebugOption> detectorDebugOptions) {
            this.detectorDebugOptions = DetectorDebugOptionsCopier.copy(detectorDebugOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorDebugOptions(DetectorDebugOption ... detectorDebugOptions) {
            this.detectorDebugOptions(Arrays.asList(detectorDebugOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorDebugOptions(Consumer<DetectorDebugOption.Builder> ... detectorDebugOptions) {
            this.detectorDebugOptions(Stream.of(detectorDebugOptions).map(c -> (DetectorDebugOption)((DetectorDebugOption.Builder)DetectorDebugOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetectorDebugOptions(Collection<DetectorDebugOption.BuilderImpl> detectorDebugOptions) {
            this.detectorDebugOptions = DetectorDebugOptionsCopier.copyFromBuilder(detectorDebugOptions);
        }

        public LoggingOptions build() {
            return new LoggingOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingOptions> {
        public Builder roleArn(String var1);

        public Builder level(String var1);

        public Builder level(LoggingLevel var1);

        public Builder enabled(Boolean var1);

        public Builder detectorDebugOptions(Collection<DetectorDebugOption> var1);

        public Builder detectorDebugOptions(DetectorDebugOption ... var1);

        public Builder detectorDebugOptions(Consumer<DetectorDebugOption.Builder> ... var1);
    }
}

