/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.InputDefinition;
import software.amazon.awssdk.services.iotevents.model.IotEventsRequest;
import software.amazon.awssdk.services.iotevents.model.Tag;
import software.amazon.awssdk.services.iotevents.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInputRequest
extends IotEventsRequest
implements ToCopyableBuilder<Builder, CreateInputRequest> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInputRequest.getter(CreateInputRequest::inputName)).setter(CreateInputRequest.setter(Builder::inputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()}).build();
    private static final SdkField<String> INPUT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateInputRequest.getter(CreateInputRequest::inputDescription)).setter(CreateInputRequest.setter(Builder::inputDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDescription").build()}).build();
    private static final SdkField<InputDefinition> INPUT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateInputRequest.getter(CreateInputRequest::inputDefinition)).setter(CreateInputRequest.setter(Builder::inputDefinition)).constructor(InputDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDefinition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateInputRequest.getter(CreateInputRequest::tags)).setter(CreateInputRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD, INPUT_DESCRIPTION_FIELD, INPUT_DEFINITION_FIELD, TAGS_FIELD));
    private final String inputName;
    private final String inputDescription;
    private final InputDefinition inputDefinition;
    private final List<Tag> tags;

    private CreateInputRequest(BuilderImpl builder) {
        super(builder);
        this.inputName = builder.inputName;
        this.inputDescription = builder.inputDescription;
        this.inputDefinition = builder.inputDefinition;
        this.tags = builder.tags;
    }

    public String inputName() {
        return this.inputName;
    }

    public String inputDescription() {
        return this.inputDescription;
    }

    public InputDefinition inputDefinition() {
        return this.inputDefinition;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInputRequest)) {
            return false;
        }
        CreateInputRequest other = (CreateInputRequest)((Object)obj);
        return Objects.equals(this.inputName(), other.inputName()) && Objects.equals(this.inputDescription(), other.inputDescription()) && Objects.equals(this.inputDefinition(), other.inputDefinition()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateInputRequest").add("InputName", (Object)this.inputName()).add("InputDescription", (Object)this.inputDescription()).add("InputDefinition", (Object)this.inputDefinition()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputName": {
                return Optional.ofNullable(clazz.cast(this.inputName()));
            }
            case "inputDescription": {
                return Optional.ofNullable(clazz.cast(this.inputDescription()));
            }
            case "inputDefinition": {
                return Optional.ofNullable(clazz.cast(this.inputDefinition()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInputRequest, T> g) {
        return obj -> g.apply((CreateInputRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsRequest.BuilderImpl
    implements Builder {
        private String inputName;
        private String inputDescription;
        private InputDefinition inputDefinition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInputRequest model) {
            super(model);
            this.inputName(model.inputName);
            this.inputDescription(model.inputDescription);
            this.inputDefinition(model.inputDefinition);
            this.tags(model.tags);
        }

        public final String getInputName() {
            return this.inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        public final String getInputDescription() {
            return this.inputDescription;
        }

        @Override
        public final Builder inputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
            return this;
        }

        public final void setInputDescription(String inputDescription) {
            this.inputDescription = inputDescription;
        }

        public final InputDefinition.Builder getInputDefinition() {
            return this.inputDefinition != null ? this.inputDefinition.toBuilder() : null;
        }

        @Override
        public final Builder inputDefinition(InputDefinition inputDefinition) {
            this.inputDefinition = inputDefinition;
            return this;
        }

        public final void setInputDefinition(InputDefinition.BuilderImpl inputDefinition) {
            this.inputDefinition = inputDefinition != null ? inputDefinition.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInputRequest build() {
            return new CreateInputRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInputRequest> {
        public Builder inputName(String var1);

        public Builder inputDescription(String var1);

        public Builder inputDefinition(InputDefinition var1);

        default public Builder inputDefinition(Consumer<InputDefinition.Builder> inputDefinition) {
            return this.inputDefinition((InputDefinition)((InputDefinition.Builder)InputDefinition.builder().applyMutation(inputDefinition)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

