/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.EmailContent;
import software.amazon.awssdk.services.iotevents.model.EmailRecipients;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailConfiguration> {
    private static final SdkField<String> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("from").getter(EmailConfiguration.getter(EmailConfiguration::from)).setter(EmailConfiguration.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()}).build();
    private static final SdkField<EmailContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(EmailConfiguration.getter(EmailConfiguration::content)).setter(EmailConfiguration.setter(Builder::content)).constructor(EmailContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<EmailRecipients> RECIPIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recipients").getter(EmailConfiguration.getter(EmailConfiguration::recipients)).setter(EmailConfiguration.setter(Builder::recipients)).constructor(EmailRecipients::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipients").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, CONTENT_FIELD, RECIPIENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EmailConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String from;
    private final EmailContent content;
    private final EmailRecipients recipients;

    private EmailConfiguration(BuilderImpl builder) {
        this.from = builder.from;
        this.content = builder.content;
        this.recipients = builder.recipients;
    }

    public final String from() {
        return this.from;
    }

    public final EmailContent content() {
        return this.content;
    }

    public final EmailRecipients recipients() {
        return this.recipients;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipients());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailConfiguration)) {
            return false;
        }
        EmailConfiguration other = (EmailConfiguration)obj;
        return Objects.equals(this.from(), other.from()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.recipients(), other.recipients());
    }

    public final String toString() {
        return ToString.builder((String)"EmailConfiguration").add("From", (Object)this.from()).add("Content", (Object)this.content()).add("Recipients", (Object)this.recipients()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "from": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "recipients": {
                return Optional.ofNullable(clazz.cast(this.recipients()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("from", FROM_FIELD);
        map.put("content", CONTENT_FIELD);
        map.put("recipients", RECIPIENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EmailConfiguration, T> g) {
        return obj -> g.apply((EmailConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String from;
        private EmailContent content;
        private EmailRecipients recipients;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailConfiguration model) {
            this.from(model.from);
            this.content(model.content);
            this.recipients(model.recipients);
        }

        public final String getFrom() {
            return this.from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final EmailContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(EmailContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(EmailContent content) {
            this.content = content;
            return this;
        }

        public final EmailRecipients.Builder getRecipients() {
            return this.recipients != null ? this.recipients.toBuilder() : null;
        }

        public final void setRecipients(EmailRecipients.BuilderImpl recipients) {
            this.recipients = recipients != null ? recipients.build() : null;
        }

        @Override
        public final Builder recipients(EmailRecipients recipients) {
            this.recipients = recipients;
            return this;
        }

        public EmailConfiguration build() {
            return new EmailConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailConfiguration> {
        public Builder from(String var1);

        public Builder content(EmailContent var1);

        default public Builder content(Consumer<EmailContent.Builder> content) {
            return this.content((EmailContent)((EmailContent.Builder)EmailContent.builder().applyMutation(content)).build());
        }

        public Builder recipients(EmailRecipients var1);

        default public Builder recipients(Consumer<EmailRecipients.Builder> recipients) {
            return this.recipients((EmailRecipients)((EmailRecipients.Builder)EmailRecipients.builder().applyMutation(recipients)).build());
        }
    }
}

