/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.AlarmCapabilities;
import software.amazon.awssdk.services.iotevents.model.AlarmEventActions;
import software.amazon.awssdk.services.iotevents.model.AlarmModelVersionStatus;
import software.amazon.awssdk.services.iotevents.model.AlarmNotification;
import software.amazon.awssdk.services.iotevents.model.AlarmRule;
import software.amazon.awssdk.services.iotevents.model.IotEventsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmModelResponse
extends IotEventsResponse
implements ToCopyableBuilder<Builder, DescribeAlarmModelResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::creationTime)).setter(DescribeAlarmModelResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> ALARM_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelArn").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::alarmModelArn)).setter(DescribeAlarmModelResponse.setter(Builder::alarmModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelArn").build()}).build();
    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelVersion").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::alarmModelVersion)).setter(DescribeAlarmModelResponse.setter(Builder::alarmModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::lastUpdateTime)).setter(DescribeAlarmModelResponse.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::statusAsString)).setter(DescribeAlarmModelResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::statusMessage)).setter(DescribeAlarmModelResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelName").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::alarmModelName)).setter(DescribeAlarmModelResponse.setter(Builder::alarmModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()}).build();
    private static final SdkField<String> ALARM_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelDescription").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::alarmModelDescription)).setter(DescribeAlarmModelResponse.setter(Builder::alarmModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelDescription").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::roleArn)).setter(DescribeAlarmModelResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::key)).setter(DescribeAlarmModelResponse.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<Integer> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("severity").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::severity)).setter(DescribeAlarmModelResponse.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<AlarmRule> ALARM_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmRule").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::alarmRule)).setter(DescribeAlarmModelResponse.setter(Builder::alarmRule)).constructor(AlarmRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmRule").build()}).build();
    private static final SdkField<AlarmNotification> ALARM_NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmNotification").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::alarmNotification)).setter(DescribeAlarmModelResponse.setter(Builder::alarmNotification)).constructor(AlarmNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmNotification").build()}).build();
    private static final SdkField<AlarmEventActions> ALARM_EVENT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmEventActions").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::alarmEventActions)).setter(DescribeAlarmModelResponse.setter(Builder::alarmEventActions)).constructor(AlarmEventActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmEventActions").build()}).build();
    private static final SdkField<AlarmCapabilities> ALARM_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmCapabilities").getter(DescribeAlarmModelResponse.getter(DescribeAlarmModelResponse::alarmCapabilities)).setter(DescribeAlarmModelResponse.setter(Builder::alarmCapabilities)).constructor(AlarmCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmCapabilities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, ALARM_MODEL_ARN_FIELD, ALARM_MODEL_VERSION_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, ALARM_MODEL_NAME_FIELD, ALARM_MODEL_DESCRIPTION_FIELD, ROLE_ARN_FIELD, KEY_FIELD, SEVERITY_FIELD, ALARM_RULE_FIELD, ALARM_NOTIFICATION_FIELD, ALARM_EVENT_ACTIONS_FIELD, ALARM_CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAlarmModelResponse.memberNameToFieldInitializer();
    private final Instant creationTime;
    private final String alarmModelArn;
    private final String alarmModelVersion;
    private final Instant lastUpdateTime;
    private final String status;
    private final String statusMessage;
    private final String alarmModelName;
    private final String alarmModelDescription;
    private final String roleArn;
    private final String key;
    private final Integer severity;
    private final AlarmRule alarmRule;
    private final AlarmNotification alarmNotification;
    private final AlarmEventActions alarmEventActions;
    private final AlarmCapabilities alarmCapabilities;

    private DescribeAlarmModelResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.alarmModelArn = builder.alarmModelArn;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelDescription = builder.alarmModelDescription;
        this.roleArn = builder.roleArn;
        this.key = builder.key;
        this.severity = builder.severity;
        this.alarmRule = builder.alarmRule;
        this.alarmNotification = builder.alarmNotification;
        this.alarmEventActions = builder.alarmEventActions;
        this.alarmCapabilities = builder.alarmCapabilities;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String alarmModelArn() {
        return this.alarmModelArn;
    }

    public final String alarmModelVersion() {
        return this.alarmModelVersion;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final AlarmModelVersionStatus status() {
        return AlarmModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String alarmModelName() {
        return this.alarmModelName;
    }

    public final String alarmModelDescription() {
        return this.alarmModelDescription;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String key() {
        return this.key;
    }

    public final Integer severity() {
        return this.severity;
    }

    public final AlarmRule alarmRule() {
        return this.alarmRule;
    }

    public final AlarmNotification alarmNotification() {
        return this.alarmNotification;
    }

    public final AlarmEventActions alarmEventActions() {
        return this.alarmEventActions;
    }

    public final AlarmCapabilities alarmCapabilities() {
        return this.alarmCapabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmNotification());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmEventActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmCapabilities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmModelResponse)) {
            return false;
        }
        DescribeAlarmModelResponse other = (DescribeAlarmModelResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.alarmModelArn(), other.alarmModelArn()) && Objects.equals(this.alarmModelVersion(), other.alarmModelVersion()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.alarmModelName(), other.alarmModelName()) && Objects.equals(this.alarmModelDescription(), other.alarmModelDescription()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.alarmRule(), other.alarmRule()) && Objects.equals(this.alarmNotification(), other.alarmNotification()) && Objects.equals(this.alarmEventActions(), other.alarmEventActions()) && Objects.equals(this.alarmCapabilities(), other.alarmCapabilities());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAlarmModelResponse").add("CreationTime", (Object)this.creationTime()).add("AlarmModelArn", (Object)this.alarmModelArn()).add("AlarmModelVersion", (Object)this.alarmModelVersion()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("AlarmModelName", (Object)this.alarmModelName()).add("AlarmModelDescription", (Object)this.alarmModelDescription()).add("RoleArn", (Object)this.roleArn()).add("Key", (Object)this.key()).add("Severity", (Object)this.severity()).add("AlarmRule", (Object)this.alarmRule()).add("AlarmNotification", (Object)this.alarmNotification()).add("AlarmEventActions", (Object)this.alarmEventActions()).add("AlarmCapabilities", (Object)this.alarmCapabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "alarmModelArn": {
                return Optional.ofNullable(clazz.cast(this.alarmModelArn()));
            }
            case "alarmModelVersion": {
                return Optional.ofNullable(clazz.cast(this.alarmModelVersion()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "alarmModelName": {
                return Optional.ofNullable(clazz.cast(this.alarmModelName()));
            }
            case "alarmModelDescription": {
                return Optional.ofNullable(clazz.cast(this.alarmModelDescription()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "alarmRule": {
                return Optional.ofNullable(clazz.cast(this.alarmRule()));
            }
            case "alarmNotification": {
                return Optional.ofNullable(clazz.cast(this.alarmNotification()));
            }
            case "alarmEventActions": {
                return Optional.ofNullable(clazz.cast(this.alarmEventActions()));
            }
            case "alarmCapabilities": {
                return Optional.ofNullable(clazz.cast(this.alarmCapabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("alarmModelArn", ALARM_MODEL_ARN_FIELD);
        map.put("alarmModelVersion", ALARM_MODEL_VERSION_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("alarmModelName", ALARM_MODEL_NAME_FIELD);
        map.put("alarmModelDescription", ALARM_MODEL_DESCRIPTION_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("key", KEY_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("alarmRule", ALARM_RULE_FIELD);
        map.put("alarmNotification", ALARM_NOTIFICATION_FIELD);
        map.put("alarmEventActions", ALARM_EVENT_ACTIONS_FIELD);
        map.put("alarmCapabilities", ALARM_CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmModelResponse, T> g) {
        return obj -> g.apply((DescribeAlarmModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String alarmModelArn;
        private String alarmModelVersion;
        private Instant lastUpdateTime;
        private String status;
        private String statusMessage;
        private String alarmModelName;
        private String alarmModelDescription;
        private String roleArn;
        private String key;
        private Integer severity;
        private AlarmRule alarmRule;
        private AlarmNotification alarmNotification;
        private AlarmEventActions alarmEventActions;
        private AlarmCapabilities alarmCapabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmModelResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.alarmModelArn(model.alarmModelArn);
            this.alarmModelVersion(model.alarmModelVersion);
            this.lastUpdateTime(model.lastUpdateTime);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.alarmModelName(model.alarmModelName);
            this.alarmModelDescription(model.alarmModelDescription);
            this.roleArn(model.roleArn);
            this.key(model.key);
            this.severity(model.severity);
            this.alarmRule(model.alarmRule);
            this.alarmNotification(model.alarmNotification);
            this.alarmEventActions(model.alarmEventActions);
            this.alarmCapabilities(model.alarmCapabilities);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlarmModelArn() {
            return this.alarmModelArn;
        }

        public final void setAlarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
        }

        @Override
        public final Builder alarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
            return this;
        }

        public final String getAlarmModelVersion() {
            return this.alarmModelVersion;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        @Override
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AlarmModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getAlarmModelName() {
            return this.alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getAlarmModelDescription() {
            return this.alarmModelDescription;
        }

        public final void setAlarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
        }

        @Override
        public final Builder alarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Integer getSeverity() {
            return this.severity;
        }

        public final void setSeverity(Integer severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(Integer severity) {
            this.severity = severity;
            return this;
        }

        public final AlarmRule.Builder getAlarmRule() {
            return this.alarmRule != null ? this.alarmRule.toBuilder() : null;
        }

        public final void setAlarmRule(AlarmRule.BuilderImpl alarmRule) {
            this.alarmRule = alarmRule != null ? alarmRule.build() : null;
        }

        @Override
        public final Builder alarmRule(AlarmRule alarmRule) {
            this.alarmRule = alarmRule;
            return this;
        }

        public final AlarmNotification.Builder getAlarmNotification() {
            return this.alarmNotification != null ? this.alarmNotification.toBuilder() : null;
        }

        public final void setAlarmNotification(AlarmNotification.BuilderImpl alarmNotification) {
            this.alarmNotification = alarmNotification != null ? alarmNotification.build() : null;
        }

        @Override
        public final Builder alarmNotification(AlarmNotification alarmNotification) {
            this.alarmNotification = alarmNotification;
            return this;
        }

        public final AlarmEventActions.Builder getAlarmEventActions() {
            return this.alarmEventActions != null ? this.alarmEventActions.toBuilder() : null;
        }

        public final void setAlarmEventActions(AlarmEventActions.BuilderImpl alarmEventActions) {
            this.alarmEventActions = alarmEventActions != null ? alarmEventActions.build() : null;
        }

        @Override
        public final Builder alarmEventActions(AlarmEventActions alarmEventActions) {
            this.alarmEventActions = alarmEventActions;
            return this;
        }

        public final AlarmCapabilities.Builder getAlarmCapabilities() {
            return this.alarmCapabilities != null ? this.alarmCapabilities.toBuilder() : null;
        }

        public final void setAlarmCapabilities(AlarmCapabilities.BuilderImpl alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities != null ? alarmCapabilities.build() : null;
        }

        @Override
        public final Builder alarmCapabilities(AlarmCapabilities alarmCapabilities) {
            this.alarmCapabilities = alarmCapabilities;
            return this;
        }

        @Override
        public DescribeAlarmModelResponse build() {
            return new DescribeAlarmModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmModelResponse> {
        public Builder creationTime(Instant var1);

        public Builder alarmModelArn(String var1);

        public Builder alarmModelVersion(String var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(AlarmModelVersionStatus var1);

        public Builder statusMessage(String var1);

        public Builder alarmModelName(String var1);

        public Builder alarmModelDescription(String var1);

        public Builder roleArn(String var1);

        public Builder key(String var1);

        public Builder severity(Integer var1);

        public Builder alarmRule(AlarmRule var1);

        default public Builder alarmRule(Consumer<AlarmRule.Builder> alarmRule) {
            return this.alarmRule((AlarmRule)((AlarmRule.Builder)AlarmRule.builder().applyMutation(alarmRule)).build());
        }

        public Builder alarmNotification(AlarmNotification var1);

        default public Builder alarmNotification(Consumer<AlarmNotification.Builder> alarmNotification) {
            return this.alarmNotification((AlarmNotification)((AlarmNotification.Builder)AlarmNotification.builder().applyMutation(alarmNotification)).build());
        }

        public Builder alarmEventActions(AlarmEventActions var1);

        default public Builder alarmEventActions(Consumer<AlarmEventActions.Builder> alarmEventActions) {
            return this.alarmEventActions((AlarmEventActions)((AlarmEventActions.Builder)AlarmEventActions.builder().applyMutation(alarmEventActions)).build());
        }

        public Builder alarmCapabilities(AlarmCapabilities var1);

        default public Builder alarmCapabilities(Consumer<AlarmCapabilities.Builder> alarmCapabilities) {
            return this.alarmCapabilities((AlarmCapabilities)((AlarmCapabilities.Builder)AlarmCapabilities.builder().applyMutation(alarmCapabilities)).build());
        }
    }
}

