/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.AcknowledgeFlow;
import software.amazon.awssdk.services.iotevents.model.InitializationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmCapabilities> {
    private static final SdkField<InitializationConfiguration> INITIALIZATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("initializationConfiguration").getter(AlarmCapabilities.getter(AlarmCapabilities::initializationConfiguration)).setter(AlarmCapabilities.setter(Builder::initializationConfiguration)).constructor(InitializationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationConfiguration").build()}).build();
    private static final SdkField<AcknowledgeFlow> ACKNOWLEDGE_FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acknowledgeFlow").getter(AlarmCapabilities.getter(AlarmCapabilities::acknowledgeFlow)).setter(AlarmCapabilities.setter(Builder::acknowledgeFlow)).constructor(AcknowledgeFlow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acknowledgeFlow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIALIZATION_CONFIGURATION_FIELD, ACKNOWLEDGE_FLOW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlarmCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InitializationConfiguration initializationConfiguration;
    private final AcknowledgeFlow acknowledgeFlow;

    private AlarmCapabilities(BuilderImpl builder) {
        this.initializationConfiguration = builder.initializationConfiguration;
        this.acknowledgeFlow = builder.acknowledgeFlow;
    }

    public final InitializationConfiguration initializationConfiguration() {
        return this.initializationConfiguration;
    }

    public final AcknowledgeFlow acknowledgeFlow() {
        return this.acknowledgeFlow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.initializationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.acknowledgeFlow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmCapabilities)) {
            return false;
        }
        AlarmCapabilities other = (AlarmCapabilities)obj;
        return Objects.equals(this.initializationConfiguration(), other.initializationConfiguration()) && Objects.equals(this.acknowledgeFlow(), other.acknowledgeFlow());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmCapabilities").add("InitializationConfiguration", (Object)this.initializationConfiguration()).add("AcknowledgeFlow", (Object)this.acknowledgeFlow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "initializationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.initializationConfiguration()));
            }
            case "acknowledgeFlow": {
                return Optional.ofNullable(clazz.cast(this.acknowledgeFlow()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("initializationConfiguration", INITIALIZATION_CONFIGURATION_FIELD);
        map.put("acknowledgeFlow", ACKNOWLEDGE_FLOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlarmCapabilities, T> g) {
        return obj -> g.apply((AlarmCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InitializationConfiguration initializationConfiguration;
        private AcknowledgeFlow acknowledgeFlow;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmCapabilities model) {
            this.initializationConfiguration(model.initializationConfiguration);
            this.acknowledgeFlow(model.acknowledgeFlow);
        }

        public final InitializationConfiguration.Builder getInitializationConfiguration() {
            return this.initializationConfiguration != null ? this.initializationConfiguration.toBuilder() : null;
        }

        public final void setInitializationConfiguration(InitializationConfiguration.BuilderImpl initializationConfiguration) {
            this.initializationConfiguration = initializationConfiguration != null ? initializationConfiguration.build() : null;
        }

        @Override
        public final Builder initializationConfiguration(InitializationConfiguration initializationConfiguration) {
            this.initializationConfiguration = initializationConfiguration;
            return this;
        }

        public final AcknowledgeFlow.Builder getAcknowledgeFlow() {
            return this.acknowledgeFlow != null ? this.acknowledgeFlow.toBuilder() : null;
        }

        public final void setAcknowledgeFlow(AcknowledgeFlow.BuilderImpl acknowledgeFlow) {
            this.acknowledgeFlow = acknowledgeFlow != null ? acknowledgeFlow.build() : null;
        }

        @Override
        public final Builder acknowledgeFlow(AcknowledgeFlow acknowledgeFlow) {
            this.acknowledgeFlow = acknowledgeFlow;
            return this;
        }

        public AlarmCapabilities build() {
            return new AlarmCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmCapabilities> {
        public Builder initializationConfiguration(InitializationConfiguration var1);

        default public Builder initializationConfiguration(Consumer<InitializationConfiguration.Builder> initializationConfiguration) {
            return this.initializationConfiguration((InitializationConfiguration)((InitializationConfiguration.Builder)InitializationConfiguration.builder().applyMutation(initializationConfiguration)).build());
        }

        public Builder acknowledgeFlow(AcknowledgeFlow var1);

        default public Builder acknowledgeFlow(Consumer<AcknowledgeFlow.Builder> acknowledgeFlow) {
            return this.acknowledgeFlow((AcknowledgeFlow)((AcknowledgeFlow.Builder)AcknowledgeFlow.builder().applyMutation(acknowledgeFlow)).build());
        }
    }
}

