/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.iotevents.IotEventsClient;
import software.amazon.awssdk.services.iotevents.IotEventsServiceClientConfiguration;
import software.amazon.awssdk.services.iotevents.internal.IotEventsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iotevents.model.CreateAlarmModelRequest;
import software.amazon.awssdk.services.iotevents.model.CreateAlarmModelResponse;
import software.amazon.awssdk.services.iotevents.model.CreateDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.CreateDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.CreateInputRequest;
import software.amazon.awssdk.services.iotevents.model.CreateInputResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteAlarmModelRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteAlarmModelResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.DeleteInputRequest;
import software.amazon.awssdk.services.iotevents.model.DeleteInputResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeAlarmModelRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeAlarmModelResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelAnalysisRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelAnalysisResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeInputRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeInputResponse;
import software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsRequest;
import software.amazon.awssdk.services.iotevents.model.DescribeLoggingOptionsResponse;
import software.amazon.awssdk.services.iotevents.model.GetDetectorModelAnalysisResultsRequest;
import software.amazon.awssdk.services.iotevents.model.GetDetectorModelAnalysisResultsResponse;
import software.amazon.awssdk.services.iotevents.model.InternalFailureException;
import software.amazon.awssdk.services.iotevents.model.InvalidRequestException;
import software.amazon.awssdk.services.iotevents.model.IotEventsException;
import software.amazon.awssdk.services.iotevents.model.LimitExceededException;
import software.amazon.awssdk.services.iotevents.model.ListAlarmModelVersionsRequest;
import software.amazon.awssdk.services.iotevents.model.ListAlarmModelVersionsResponse;
import software.amazon.awssdk.services.iotevents.model.ListAlarmModelsRequest;
import software.amazon.awssdk.services.iotevents.model.ListAlarmModelsResponse;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsRequest;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelVersionsResponse;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelsRequest;
import software.amazon.awssdk.services.iotevents.model.ListDetectorModelsResponse;
import software.amazon.awssdk.services.iotevents.model.ListInputRoutingsRequest;
import software.amazon.awssdk.services.iotevents.model.ListInputRoutingsResponse;
import software.amazon.awssdk.services.iotevents.model.ListInputsRequest;
import software.amazon.awssdk.services.iotevents.model.ListInputsResponse;
import software.amazon.awssdk.services.iotevents.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotevents.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsRequest;
import software.amazon.awssdk.services.iotevents.model.PutLoggingOptionsResponse;
import software.amazon.awssdk.services.iotevents.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotevents.model.ResourceInUseException;
import software.amazon.awssdk.services.iotevents.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotevents.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotevents.model.StartDetectorModelAnalysisRequest;
import software.amazon.awssdk.services.iotevents.model.StartDetectorModelAnalysisResponse;
import software.amazon.awssdk.services.iotevents.model.TagResourceRequest;
import software.amazon.awssdk.services.iotevents.model.TagResourceResponse;
import software.amazon.awssdk.services.iotevents.model.ThrottlingException;
import software.amazon.awssdk.services.iotevents.model.UnsupportedOperationException;
import software.amazon.awssdk.services.iotevents.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotevents.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateAlarmModelRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateAlarmModelResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateDetectorModelResponse;
import software.amazon.awssdk.services.iotevents.model.UpdateInputRequest;
import software.amazon.awssdk.services.iotevents.model.UpdateInputResponse;
import software.amazon.awssdk.services.iotevents.transform.CreateAlarmModelRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.CreateDetectorModelRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.CreateInputRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.DeleteAlarmModelRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.DeleteDetectorModelRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.DeleteInputRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.DescribeAlarmModelRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.DescribeDetectorModelAnalysisRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.DescribeDetectorModelRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.DescribeInputRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.DescribeLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.GetDetectorModelAnalysisResultsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.ListAlarmModelVersionsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.ListAlarmModelsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.ListDetectorModelVersionsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.ListDetectorModelsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.ListInputRoutingsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.ListInputsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.PutLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.StartDetectorModelAnalysisRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.UpdateAlarmModelRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.UpdateDetectorModelRequestMarshaller;
import software.amazon.awssdk.services.iotevents.transform.UpdateInputRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultIotEventsClient
implements IotEventsClient {
    private static final Logger log = Logger.loggerFor(DefaultIotEventsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotEventsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAlarmModelResponse createAlarmModel(CreateAlarmModelRequest createAlarmModelRequest) throws InvalidRequestException, ResourceInUseException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAlarmModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAlarmModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, createAlarmModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAlarmModel");
            CreateAlarmModelResponse createAlarmModelResponse = (CreateAlarmModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAlarmModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAlarmModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAlarmModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAlarmModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$createAlarmModel$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDetectorModelResponse createDetectorModel(CreateDetectorModelRequest createDetectorModelRequest) throws InvalidRequestException, ResourceInUseException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDetectorModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDetectorModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, createDetectorModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDetectorModel");
            CreateDetectorModelResponse createDetectorModelResponse = (CreateDetectorModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDetectorModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDetectorModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDetectorModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDetectorModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$createDetectorModel$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInputResponse createInput(CreateInputRequest createInputRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, createInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInput");
            CreateInputResponse createInputResponse = (CreateInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$createInput$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAlarmModelResponse deleteAlarmModel(DeleteAlarmModelRequest deleteAlarmModelRequest) throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAlarmModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAlarmModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, deleteAlarmModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlarmModel");
            DeleteAlarmModelResponse deleteAlarmModelResponse = (DeleteAlarmModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlarmModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAlarmModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAlarmModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAlarmModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$deleteAlarmModel$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDetectorModelResponse deleteDetectorModel(DeleteDetectorModelRequest deleteDetectorModelRequest) throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDetectorModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDetectorModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, deleteDetectorModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDetectorModel");
            DeleteDetectorModelResponse deleteDetectorModelResponse = (DeleteDetectorModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDetectorModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDetectorModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDetectorModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDetectorModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$deleteDetectorModel$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInputResponse deleteInput(DeleteInputRequest deleteInputRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, ResourceInUseException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, deleteInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInput");
            DeleteInputResponse deleteInputResponse = (DeleteInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$deleteInput$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAlarmModelResponse describeAlarmModel(DescribeAlarmModelRequest describeAlarmModelRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAlarmModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAlarmModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, describeAlarmModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarmModel");
            DescribeAlarmModelResponse describeAlarmModelResponse = (DescribeAlarmModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarmModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAlarmModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAlarmModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAlarmModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$describeAlarmModel$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDetectorModelResponse describeDetectorModel(DescribeDetectorModelRequest describeDetectorModelRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDetectorModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDetectorModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, describeDetectorModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDetectorModel");
            DescribeDetectorModelResponse describeDetectorModelResponse = (DescribeDetectorModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDetectorModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDetectorModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDetectorModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDetectorModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$describeDetectorModel$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDetectorModelAnalysisResponse describeDetectorModelAnalysis(DescribeDetectorModelAnalysisRequest describeDetectorModelAnalysisRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDetectorModelAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDetectorModelAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, describeDetectorModelAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDetectorModelAnalysis");
            DescribeDetectorModelAnalysisResponse describeDetectorModelAnalysisResponse = (DescribeDetectorModelAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDetectorModelAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeDetectorModelAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDetectorModelAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeDetectorModelAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$describeDetectorModelAnalysis$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInputResponse describeInput(DescribeInputRequest describeInputRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, describeInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInput");
            DescribeInputResponse describeInputResponse = (DescribeInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$describeInput$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoggingOptionsResponse describeLoggingOptions(DescribeLoggingOptionsRequest describeLoggingOptionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, ServiceUnavailableException, UnsupportedOperationException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLoggingOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLoggingOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, describeLoggingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoggingOptions");
            DescribeLoggingOptionsResponse describeLoggingOptionsResponse = (DescribeLoggingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoggingOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeLoggingOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoggingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLoggingOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$describeLoggingOptions$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDetectorModelAnalysisResultsResponse getDetectorModelAnalysisResults(GetDetectorModelAnalysisResultsRequest getDetectorModelAnalysisResultsRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDetectorModelAnalysisResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDetectorModelAnalysisResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, getDetectorModelAnalysisResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDetectorModelAnalysisResults");
            GetDetectorModelAnalysisResultsResponse getDetectorModelAnalysisResultsResponse = (GetDetectorModelAnalysisResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDetectorModelAnalysisResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDetectorModelAnalysisResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDetectorModelAnalysisResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDetectorModelAnalysisResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$getDetectorModelAnalysisResults$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAlarmModelVersionsResponse listAlarmModelVersions(ListAlarmModelVersionsRequest listAlarmModelVersionsRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAlarmModelVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAlarmModelVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, listAlarmModelVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAlarmModelVersions");
            ListAlarmModelVersionsResponse listAlarmModelVersionsResponse = (ListAlarmModelVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAlarmModelVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAlarmModelVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAlarmModelVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAlarmModelVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$listAlarmModelVersions$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAlarmModelsResponse listAlarmModels(ListAlarmModelsRequest listAlarmModelsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAlarmModelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAlarmModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, listAlarmModelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAlarmModels");
            ListAlarmModelsResponse listAlarmModelsResponse = (ListAlarmModelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAlarmModels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAlarmModelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAlarmModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAlarmModelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$listAlarmModels$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDetectorModelVersionsResponse listDetectorModelVersions(ListDetectorModelVersionsRequest listDetectorModelVersionsRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDetectorModelVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDetectorModelVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, listDetectorModelVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDetectorModelVersions");
            ListDetectorModelVersionsResponse listDetectorModelVersionsResponse = (ListDetectorModelVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDetectorModelVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDetectorModelVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDetectorModelVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDetectorModelVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$listDetectorModelVersions$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDetectorModelsResponse listDetectorModels(ListDetectorModelsRequest listDetectorModelsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDetectorModelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDetectorModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, listDetectorModelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDetectorModels");
            ListDetectorModelsResponse listDetectorModelsResponse = (ListDetectorModelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDetectorModels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDetectorModelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDetectorModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDetectorModelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$listDetectorModels$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInputRoutingsResponse listInputRoutings(ListInputRoutingsRequest listInputRoutingsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInputRoutingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInputRoutingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, listInputRoutingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInputRoutings");
            ListInputRoutingsResponse listInputRoutingsResponse = (ListInputRoutingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInputRoutings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInputRoutingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInputRoutingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInputRoutingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$listInputRoutings$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInputsResponse listInputs(ListInputsRequest listInputsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInputsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, listInputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInputs");
            ListInputsResponse listInputsResponse = (ListInputsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInputs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInputsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInputsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$listInputs$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$listTagsForResource$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutLoggingOptionsResponse putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ServiceUnavailableException, UnsupportedOperationException, ResourceInUseException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutLoggingOptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putLoggingOptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, putLoggingOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutLoggingOptions");
            PutLoggingOptionsResponse putLoggingOptionsResponse = (PutLoggingOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutLoggingOptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putLoggingOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutLoggingOptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putLoggingOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$putLoggingOptions$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDetectorModelAnalysisResponse startDetectorModelAnalysis(StartDetectorModelAnalysisRequest startDetectorModelAnalysisRequest) throws InvalidRequestException, LimitExceededException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDetectorModelAnalysisResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDetectorModelAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, startDetectorModelAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDetectorModelAnalysis");
            StartDetectorModelAnalysisResponse startDetectorModelAnalysisResponse = (StartDetectorModelAnalysisResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDetectorModelAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDetectorModelAnalysisRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDetectorModelAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDetectorModelAnalysisResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$startDetectorModelAnalysis$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ThrottlingException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$tagResource$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException, ResourceNotFoundException, ResourceInUseException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$untagResource$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAlarmModelResponse updateAlarmModel(UpdateAlarmModelRequest updateAlarmModelRequest) throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAlarmModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAlarmModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, updateAlarmModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAlarmModel");
            UpdateAlarmModelResponse updateAlarmModelResponse = (UpdateAlarmModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAlarmModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAlarmModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAlarmModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAlarmModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$updateAlarmModel$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDetectorModelResponse updateDetectorModel(UpdateDetectorModelRequest updateDetectorModelRequest) throws InvalidRequestException, ResourceInUseException, ResourceNotFoundException, ThrottlingException, InternalFailureException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDetectorModelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDetectorModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, updateDetectorModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDetectorModel");
            UpdateDetectorModelResponse updateDetectorModelResponse = (UpdateDetectorModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDetectorModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDetectorModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDetectorModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDetectorModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$updateDetectorModel$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateInputResponse updateInput(UpdateInputRequest updateInputRequest) throws InvalidRequestException, ThrottlingException, ResourceNotFoundException, InternalFailureException, ServiceUnavailableException, ResourceInUseException, AwsServiceException, SdkClientException, IotEventsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InternalFailureException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalFailureException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalFailureException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(410)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(501)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "ResourceAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultIotEventsClient.resolveMetricPublishers(clientConfiguration, updateInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Events");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInput");
            UpdateInputResponse updateInputResponse = (UpdateInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotEventsClient.lambda$updateInput$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "iotevents";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        IotEventsServiceClientConfigurationBuilder serviceConfigBuilder = new IotEventsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IotEventsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final IotEventsServiceClientConfiguration serviceClientConfiguration() {
        return new IotEventsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateInput$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDetectorModel$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAlarmModel$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDetectorModelAnalysis$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putLoggingOptions$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInputs$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInputRoutings$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDetectorModels$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDetectorModelVersions$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAlarmModels$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAlarmModelVersions$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDetectorModelAnalysisResults$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoggingOptions$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInput$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDetectorModelAnalysis$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDetectorModel$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarmModel$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInput$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDetectorModel$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlarmModel$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInput$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDetectorModel$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAlarmModel$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

