/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.DetectorModelVersionStatus;
import software.amazon.awssdk.services.iotevents.model.EvaluationMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorModelConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorModelConfiguration> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelName").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::detectorModelName)).setter(DetectorModelConfiguration.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelVersion").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::detectorModelVersion)).setter(DetectorModelConfiguration.setter(Builder::detectorModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelVersion").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelDescription").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::detectorModelDescription)).setter(DetectorModelConfiguration.setter(Builder::detectorModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDescription").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelArn").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::detectorModelArn)).setter(DetectorModelConfiguration.setter(Builder::detectorModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelArn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::roleArn)).setter(DetectorModelConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::creationTime)).setter(DetectorModelConfiguration.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::lastUpdateTime)).setter(DetectorModelConfiguration.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::statusAsString)).setter(DetectorModelConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::key)).setter(DetectorModelConfiguration.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> EVALUATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationMethod").getter(DetectorModelConfiguration.getter(DetectorModelConfiguration::evaluationMethodAsString)).setter(DetectorModelConfiguration.setter(Builder::evaluationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, DETECTOR_MODEL_VERSION_FIELD, DETECTOR_MODEL_DESCRIPTION_FIELD, DETECTOR_MODEL_ARN_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD, KEY_FIELD, EVALUATION_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetectorModelConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String detectorModelName;
    private final String detectorModelVersion;
    private final String detectorModelDescription;
    private final String detectorModelArn;
    private final String roleArn;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final String status;
    private final String key;
    private final String evaluationMethod;

    private DetectorModelConfiguration(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelVersion = builder.detectorModelVersion;
        this.detectorModelDescription = builder.detectorModelDescription;
        this.detectorModelArn = builder.detectorModelArn;
        this.roleArn = builder.roleArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.key = builder.key;
        this.evaluationMethod = builder.evaluationMethod;
    }

    public final String detectorModelName() {
        return this.detectorModelName;
    }

    public final String detectorModelVersion() {
        return this.detectorModelVersion;
    }

    public final String detectorModelDescription() {
        return this.detectorModelDescription;
    }

    public final String detectorModelArn() {
        return this.detectorModelArn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final DetectorModelVersionStatus status() {
        return DetectorModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String key() {
        return this.key;
    }

    public final EvaluationMethod evaluationMethod() {
        return EvaluationMethod.fromValue(this.evaluationMethod);
    }

    public final String evaluationMethodAsString() {
        return this.evaluationMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelConfiguration)) {
            return false;
        }
        DetectorModelConfiguration other = (DetectorModelConfiguration)obj;
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.detectorModelVersion(), other.detectorModelVersion()) && Objects.equals(this.detectorModelDescription(), other.detectorModelDescription()) && Objects.equals(this.detectorModelArn(), other.detectorModelArn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.evaluationMethodAsString(), other.evaluationMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DetectorModelConfiguration").add("DetectorModelName", (Object)this.detectorModelName()).add("DetectorModelVersion", (Object)this.detectorModelVersion()).add("DetectorModelDescription", (Object)this.detectorModelDescription()).add("DetectorModelArn", (Object)this.detectorModelArn()).add("RoleArn", (Object)this.roleArn()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Status", (Object)this.statusAsString()).add("Key", (Object)this.key()).add("EvaluationMethod", (Object)this.evaluationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "detectorModelVersion": {
                return Optional.ofNullable(clazz.cast(this.detectorModelVersion()));
            }
            case "detectorModelDescription": {
                return Optional.ofNullable(clazz.cast(this.detectorModelDescription()));
            }
            case "detectorModelArn": {
                return Optional.ofNullable(clazz.cast(this.detectorModelArn()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "evaluationMethod": {
                return Optional.ofNullable(clazz.cast(this.evaluationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorModelName", DETECTOR_MODEL_NAME_FIELD);
        map.put("detectorModelVersion", DETECTOR_MODEL_VERSION_FIELD);
        map.put("detectorModelDescription", DETECTOR_MODEL_DESCRIPTION_FIELD);
        map.put("detectorModelArn", DETECTOR_MODEL_ARN_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("key", KEY_FIELD);
        map.put("evaluationMethod", EVALUATION_METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelConfiguration, T> g) {
        return obj -> g.apply((DetectorModelConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectorModelName;
        private String detectorModelVersion;
        private String detectorModelDescription;
        private String detectorModelArn;
        private String roleArn;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private String status;
        private String key;
        private String evaluationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelConfiguration model) {
            this.detectorModelName(model.detectorModelName);
            this.detectorModelVersion(model.detectorModelVersion);
            this.detectorModelDescription(model.detectorModelDescription);
            this.detectorModelArn(model.detectorModelArn);
            this.roleArn(model.roleArn);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.status(model.status);
            this.key(model.key);
            this.evaluationMethod(model.evaluationMethod);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getDetectorModelVersion() {
            return this.detectorModelVersion;
        }

        public final void setDetectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
        }

        @Override
        public final Builder detectorModelVersion(String detectorModelVersion) {
            this.detectorModelVersion = detectorModelVersion;
            return this;
        }

        public final String getDetectorModelDescription() {
            return this.detectorModelDescription;
        }

        public final void setDetectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
        }

        @Override
        public final Builder detectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
            return this;
        }

        public final String getDetectorModelArn() {
            return this.detectorModelArn;
        }

        public final void setDetectorModelArn(String detectorModelArn) {
            this.detectorModelArn = detectorModelArn;
        }

        @Override
        public final Builder detectorModelArn(String detectorModelArn) {
            this.detectorModelArn = detectorModelArn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DetectorModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getEvaluationMethod() {
            return this.evaluationMethod;
        }

        public final void setEvaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
        }

        @Override
        public final Builder evaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
            return this;
        }

        @Override
        public final Builder evaluationMethod(EvaluationMethod evaluationMethod) {
            this.evaluationMethod(evaluationMethod == null ? null : evaluationMethod.toString());
            return this;
        }

        public DetectorModelConfiguration build() {
            return new DetectorModelConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorModelConfiguration> {
        public Builder detectorModelName(String var1);

        public Builder detectorModelVersion(String var1);

        public Builder detectorModelDescription(String var1);

        public Builder detectorModelArn(String var1);

        public Builder roleArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(DetectorModelVersionStatus var1);

        public Builder key(String var1);

        public Builder evaluationMethod(String var1);

        public Builder evaluationMethod(EvaluationMethod var1);
    }
}

