/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.DynamoDBAction;
import software.amazon.awssdk.services.iotevents.model.DynamoDBv2Action;
import software.amazon.awssdk.services.iotevents.model.FirehoseAction;
import software.amazon.awssdk.services.iotevents.model.IotEventsAction;
import software.amazon.awssdk.services.iotevents.model.IotSiteWiseAction;
import software.amazon.awssdk.services.iotevents.model.IotTopicPublishAction;
import software.amazon.awssdk.services.iotevents.model.LambdaAction;
import software.amazon.awssdk.services.iotevents.model.SNSTopicPublishAction;
import software.amazon.awssdk.services.iotevents.model.SqsAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmAction> {
    private static final SdkField<SNSTopicPublishAction> SNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sns").getter(AlarmAction.getter(AlarmAction::sns)).setter(AlarmAction.setter(Builder::sns)).constructor(SNSTopicPublishAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sns").build()}).build();
    private static final SdkField<IotTopicPublishAction> IOT_TOPIC_PUBLISH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotTopicPublish").getter(AlarmAction.getter(AlarmAction::iotTopicPublish)).setter(AlarmAction.setter(Builder::iotTopicPublish)).constructor(IotTopicPublishAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotTopicPublish").build()}).build();
    private static final SdkField<LambdaAction> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambda").getter(AlarmAction.getter(AlarmAction::lambda)).setter(AlarmAction.setter(Builder::lambda)).constructor(LambdaAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final SdkField<IotEventsAction> IOT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotEvents").getter(AlarmAction.getter(AlarmAction::iotEvents)).setter(AlarmAction.setter(Builder::iotEvents)).constructor(IotEventsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotEvents").build()}).build();
    private static final SdkField<SqsAction> SQS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqs").getter(AlarmAction.getter(AlarmAction::sqs)).setter(AlarmAction.setter(Builder::sqs)).constructor(SqsAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqs").build()}).build();
    private static final SdkField<FirehoseAction> FIREHOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("firehose").getter(AlarmAction.getter(AlarmAction::firehose)).setter(AlarmAction.setter(Builder::firehose)).constructor(FirehoseAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()}).build();
    private static final SdkField<DynamoDBAction> DYNAMO_DB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dynamoDB").getter(AlarmAction.getter(AlarmAction::dynamoDB)).setter(AlarmAction.setter(Builder::dynamoDB)).constructor(DynamoDBAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDB").build()}).build();
    private static final SdkField<DynamoDBv2Action> DYNAMO_DB_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dynamoDBv2").getter(AlarmAction.getter(AlarmAction::dynamoDBv2)).setter(AlarmAction.setter(Builder::dynamoDBv2)).constructor(DynamoDBv2Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDBv2").build()}).build();
    private static final SdkField<IotSiteWiseAction> IOT_SITE_WISE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotSiteWise").getter(AlarmAction.getter(AlarmAction::iotSiteWise)).setter(AlarmAction.setter(Builder::iotSiteWise)).constructor(IotSiteWiseAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWise").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_FIELD, IOT_TOPIC_PUBLISH_FIELD, LAMBDA_FIELD, IOT_EVENTS_FIELD, SQS_FIELD, FIREHOSE_FIELD, DYNAMO_DB_FIELD, DYNAMO_DB_V2_FIELD, IOT_SITE_WISE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlarmAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SNSTopicPublishAction sns;
    private final IotTopicPublishAction iotTopicPublish;
    private final LambdaAction lambda;
    private final IotEventsAction iotEvents;
    private final SqsAction sqs;
    private final FirehoseAction firehose;
    private final DynamoDBAction dynamoDB;
    private final DynamoDBv2Action dynamoDBv2;
    private final IotSiteWiseAction iotSiteWise;

    private AlarmAction(BuilderImpl builder) {
        this.sns = builder.sns;
        this.iotTopicPublish = builder.iotTopicPublish;
        this.lambda = builder.lambda;
        this.iotEvents = builder.iotEvents;
        this.sqs = builder.sqs;
        this.firehose = builder.firehose;
        this.dynamoDB = builder.dynamoDB;
        this.dynamoDBv2 = builder.dynamoDBv2;
        this.iotSiteWise = builder.iotSiteWise;
    }

    public final SNSTopicPublishAction sns() {
        return this.sns;
    }

    public final IotTopicPublishAction iotTopicPublish() {
        return this.iotTopicPublish;
    }

    public final LambdaAction lambda() {
        return this.lambda;
    }

    public final IotEventsAction iotEvents() {
        return this.iotEvents;
    }

    public final SqsAction sqs() {
        return this.sqs;
    }

    public final FirehoseAction firehose() {
        return this.firehose;
    }

    public final DynamoDBAction dynamoDB() {
        return this.dynamoDB;
    }

    public final DynamoDBv2Action dynamoDBv2() {
        return this.dynamoDBv2;
    }

    public final IotSiteWiseAction iotSiteWise() {
        return this.iotSiteWise;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sns());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotTopicPublish());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqs());
        hashCode = 31 * hashCode + Objects.hashCode(this.firehose());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDB());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDBv2());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotSiteWise());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmAction)) {
            return false;
        }
        AlarmAction other = (AlarmAction)obj;
        return Objects.equals(this.sns(), other.sns()) && Objects.equals(this.iotTopicPublish(), other.iotTopicPublish()) && Objects.equals(this.lambda(), other.lambda()) && Objects.equals(this.iotEvents(), other.iotEvents()) && Objects.equals(this.sqs(), other.sqs()) && Objects.equals(this.firehose(), other.firehose()) && Objects.equals(this.dynamoDB(), other.dynamoDB()) && Objects.equals(this.dynamoDBv2(), other.dynamoDBv2()) && Objects.equals(this.iotSiteWise(), other.iotSiteWise());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmAction").add("Sns", (Object)this.sns()).add("IotTopicPublish", (Object)this.iotTopicPublish()).add("Lambda", (Object)this.lambda()).add("IotEvents", (Object)this.iotEvents()).add("Sqs", (Object)this.sqs()).add("Firehose", (Object)this.firehose()).add("DynamoDB", (Object)this.dynamoDB()).add("DynamoDBv2", (Object)this.dynamoDBv2()).add("IotSiteWise", (Object)this.iotSiteWise()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sns": {
                return Optional.ofNullable(clazz.cast(this.sns()));
            }
            case "iotTopicPublish": {
                return Optional.ofNullable(clazz.cast(this.iotTopicPublish()));
            }
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
            case "iotEvents": {
                return Optional.ofNullable(clazz.cast(this.iotEvents()));
            }
            case "sqs": {
                return Optional.ofNullable(clazz.cast(this.sqs()));
            }
            case "firehose": {
                return Optional.ofNullable(clazz.cast(this.firehose()));
            }
            case "dynamoDB": {
                return Optional.ofNullable(clazz.cast(this.dynamoDB()));
            }
            case "dynamoDBv2": {
                return Optional.ofNullable(clazz.cast(this.dynamoDBv2()));
            }
            case "iotSiteWise": {
                return Optional.ofNullable(clazz.cast(this.iotSiteWise()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sns", SNS_FIELD);
        map.put("iotTopicPublish", IOT_TOPIC_PUBLISH_FIELD);
        map.put("lambda", LAMBDA_FIELD);
        map.put("iotEvents", IOT_EVENTS_FIELD);
        map.put("sqs", SQS_FIELD);
        map.put("firehose", FIREHOSE_FIELD);
        map.put("dynamoDB", DYNAMO_DB_FIELD);
        map.put("dynamoDBv2", DYNAMO_DB_V2_FIELD);
        map.put("iotSiteWise", IOT_SITE_WISE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlarmAction, T> g) {
        return obj -> g.apply((AlarmAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SNSTopicPublishAction sns;
        private IotTopicPublishAction iotTopicPublish;
        private LambdaAction lambda;
        private IotEventsAction iotEvents;
        private SqsAction sqs;
        private FirehoseAction firehose;
        private DynamoDBAction dynamoDB;
        private DynamoDBv2Action dynamoDBv2;
        private IotSiteWiseAction iotSiteWise;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmAction model) {
            this.sns(model.sns);
            this.iotTopicPublish(model.iotTopicPublish);
            this.lambda(model.lambda);
            this.iotEvents(model.iotEvents);
            this.sqs(model.sqs);
            this.firehose(model.firehose);
            this.dynamoDB(model.dynamoDB);
            this.dynamoDBv2(model.dynamoDBv2);
            this.iotSiteWise(model.iotSiteWise);
        }

        public final SNSTopicPublishAction.Builder getSns() {
            return this.sns != null ? this.sns.toBuilder() : null;
        }

        public final void setSns(SNSTopicPublishAction.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        @Override
        public final Builder sns(SNSTopicPublishAction sns) {
            this.sns = sns;
            return this;
        }

        public final IotTopicPublishAction.Builder getIotTopicPublish() {
            return this.iotTopicPublish != null ? this.iotTopicPublish.toBuilder() : null;
        }

        public final void setIotTopicPublish(IotTopicPublishAction.BuilderImpl iotTopicPublish) {
            this.iotTopicPublish = iotTopicPublish != null ? iotTopicPublish.build() : null;
        }

        @Override
        public final Builder iotTopicPublish(IotTopicPublishAction iotTopicPublish) {
            this.iotTopicPublish = iotTopicPublish;
            return this;
        }

        public final LambdaAction.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaAction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(LambdaAction lambda) {
            this.lambda = lambda;
            return this;
        }

        public final IotEventsAction.Builder getIotEvents() {
            return this.iotEvents != null ? this.iotEvents.toBuilder() : null;
        }

        public final void setIotEvents(IotEventsAction.BuilderImpl iotEvents) {
            this.iotEvents = iotEvents != null ? iotEvents.build() : null;
        }

        @Override
        public final Builder iotEvents(IotEventsAction iotEvents) {
            this.iotEvents = iotEvents;
            return this;
        }

        public final SqsAction.Builder getSqs() {
            return this.sqs != null ? this.sqs.toBuilder() : null;
        }

        public final void setSqs(SqsAction.BuilderImpl sqs) {
            this.sqs = sqs != null ? sqs.build() : null;
        }

        @Override
        public final Builder sqs(SqsAction sqs) {
            this.sqs = sqs;
            return this;
        }

        public final FirehoseAction.Builder getFirehose() {
            return this.firehose != null ? this.firehose.toBuilder() : null;
        }

        public final void setFirehose(FirehoseAction.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        @Override
        public final Builder firehose(FirehoseAction firehose) {
            this.firehose = firehose;
            return this;
        }

        public final DynamoDBAction.Builder getDynamoDB() {
            return this.dynamoDB != null ? this.dynamoDB.toBuilder() : null;
        }

        public final void setDynamoDB(DynamoDBAction.BuilderImpl dynamoDB) {
            this.dynamoDB = dynamoDB != null ? dynamoDB.build() : null;
        }

        @Override
        public final Builder dynamoDB(DynamoDBAction dynamoDB) {
            this.dynamoDB = dynamoDB;
            return this;
        }

        public final DynamoDBv2Action.Builder getDynamoDBv2() {
            return this.dynamoDBv2 != null ? this.dynamoDBv2.toBuilder() : null;
        }

        public final void setDynamoDBv2(DynamoDBv2Action.BuilderImpl dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2 != null ? dynamoDBv2.build() : null;
        }

        @Override
        public final Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2;
            return this;
        }

        public final IotSiteWiseAction.Builder getIotSiteWise() {
            return this.iotSiteWise != null ? this.iotSiteWise.toBuilder() : null;
        }

        public final void setIotSiteWise(IotSiteWiseAction.BuilderImpl iotSiteWise) {
            this.iotSiteWise = iotSiteWise != null ? iotSiteWise.build() : null;
        }

        @Override
        public final Builder iotSiteWise(IotSiteWiseAction iotSiteWise) {
            this.iotSiteWise = iotSiteWise;
            return this;
        }

        public AlarmAction build() {
            return new AlarmAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmAction> {
        public Builder sns(SNSTopicPublishAction var1);

        default public Builder sns(Consumer<SNSTopicPublishAction.Builder> sns) {
            return this.sns((SNSTopicPublishAction)((SNSTopicPublishAction.Builder)SNSTopicPublishAction.builder().applyMutation(sns)).build());
        }

        public Builder iotTopicPublish(IotTopicPublishAction var1);

        default public Builder iotTopicPublish(Consumer<IotTopicPublishAction.Builder> iotTopicPublish) {
            return this.iotTopicPublish((IotTopicPublishAction)((IotTopicPublishAction.Builder)IotTopicPublishAction.builder().applyMutation(iotTopicPublish)).build());
        }

        public Builder lambda(LambdaAction var1);

        default public Builder lambda(Consumer<LambdaAction.Builder> lambda) {
            return this.lambda((LambdaAction)((LambdaAction.Builder)LambdaAction.builder().applyMutation(lambda)).build());
        }

        public Builder iotEvents(IotEventsAction var1);

        default public Builder iotEvents(Consumer<IotEventsAction.Builder> iotEvents) {
            return this.iotEvents((IotEventsAction)((IotEventsAction.Builder)IotEventsAction.builder().applyMutation(iotEvents)).build());
        }

        public Builder sqs(SqsAction var1);

        default public Builder sqs(Consumer<SqsAction.Builder> sqs) {
            return this.sqs((SqsAction)((SqsAction.Builder)SqsAction.builder().applyMutation(sqs)).build());
        }

        public Builder firehose(FirehoseAction var1);

        default public Builder firehose(Consumer<FirehoseAction.Builder> firehose) {
            return this.firehose((FirehoseAction)((FirehoseAction.Builder)FirehoseAction.builder().applyMutation(firehose)).build());
        }

        public Builder dynamoDB(DynamoDBAction var1);

        default public Builder dynamoDB(Consumer<DynamoDBAction.Builder> dynamoDB) {
            return this.dynamoDB((DynamoDBAction)((DynamoDBAction.Builder)DynamoDBAction.builder().applyMutation(dynamoDB)).build());
        }

        public Builder dynamoDBv2(DynamoDBv2Action var1);

        default public Builder dynamoDBv2(Consumer<DynamoDBv2Action.Builder> dynamoDBv2) {
            return this.dynamoDBv2((DynamoDBv2Action)((DynamoDBv2Action.Builder)DynamoDBv2Action.builder().applyMutation(dynamoDBv2)).build());
        }

        public Builder iotSiteWise(IotSiteWiseAction var1);

        default public Builder iotSiteWise(Consumer<IotSiteWiseAction.Builder> iotSiteWise) {
            return this.iotSiteWise((IotSiteWiseAction)((IotSiteWiseAction.Builder)IotSiteWiseAction.builder().applyMutation(iotSiteWise)).build());
        }
    }
}

