/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmModelSummary> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AlarmModelSummary.getter(AlarmModelSummary::creationTime)).setter(AlarmModelSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> ALARM_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelDescription").getter(AlarmModelSummary.getter(AlarmModelSummary::alarmModelDescription)).setter(AlarmModelSummary.setter(Builder::alarmModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelDescription").build()}).build();
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelName").getter(AlarmModelSummary.getter(AlarmModelSummary::alarmModelName)).setter(AlarmModelSummary.setter(Builder::alarmModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, ALARM_MODEL_DESCRIPTION_FIELD, ALARM_MODEL_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("alarmModelDescription", ALARM_MODEL_DESCRIPTION_FIELD);
            this.put("alarmModelName", ALARM_MODEL_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant creationTime;
    private final String alarmModelDescription;
    private final String alarmModelName;

    private AlarmModelSummary(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.alarmModelDescription = builder.alarmModelDescription;
        this.alarmModelName = builder.alarmModelName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String alarmModelDescription() {
        return this.alarmModelDescription;
    }

    public final String alarmModelName() {
        return this.alarmModelName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmModelSummary)) {
            return false;
        }
        AlarmModelSummary other = (AlarmModelSummary)obj;
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.alarmModelDescription(), other.alarmModelDescription()) && Objects.equals(this.alarmModelName(), other.alarmModelName());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmModelSummary").add("CreationTime", (Object)this.creationTime()).add("AlarmModelDescription", (Object)this.alarmModelDescription()).add("AlarmModelName", (Object)this.alarmModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "alarmModelDescription": {
                return Optional.ofNullable(clazz.cast(this.alarmModelDescription()));
            }
            case "alarmModelName": {
                return Optional.ofNullable(clazz.cast(this.alarmModelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AlarmModelSummary, T> g) {
        return obj -> g.apply((AlarmModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String alarmModelDescription;
        private String alarmModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmModelSummary model) {
            this.creationTime(model.creationTime);
            this.alarmModelDescription(model.alarmModelDescription);
            this.alarmModelName(model.alarmModelName);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getAlarmModelDescription() {
            return this.alarmModelDescription;
        }

        public final void setAlarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
        }

        @Override
        public final Builder alarmModelDescription(String alarmModelDescription) {
            this.alarmModelDescription = alarmModelDescription;
            return this;
        }

        public final String getAlarmModelName() {
            return this.alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public AlarmModelSummary build() {
            return new AlarmModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmModelSummary> {
        public Builder creationTime(Instant var1);

        public Builder alarmModelDescription(String var1);

        public Builder alarmModelName(String var1);
    }
}

