/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.DetectorModelSummariesCopier;
import software.amazon.awssdk.services.iotevents.model.DetectorModelSummary;
import software.amazon.awssdk.services.iotevents.model.IotEventsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDetectorModelsResponse
extends IotEventsResponse
implements ToCopyableBuilder<Builder, ListDetectorModelsResponse> {
    private static final SdkField<List<DetectorModelSummary>> DETECTOR_MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detectorModelSummaries").getter(ListDetectorModelsResponse.getter(ListDetectorModelsResponse::detectorModelSummaries)).setter(ListDetectorModelsResponse.setter(Builder::detectorModelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetectorModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDetectorModelsResponse.getter(ListDetectorModelsResponse::nextToken)).setter(ListDetectorModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("detectorModelSummaries", DETECTOR_MODEL_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<DetectorModelSummary> detectorModelSummaries;
    private final String nextToken;

    private ListDetectorModelsResponse(BuilderImpl builder) {
        super(builder);
        this.detectorModelSummaries = builder.detectorModelSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDetectorModelSummaries() {
        return this.detectorModelSummaries != null && !(this.detectorModelSummaries instanceof SdkAutoConstructList);
    }

    public final List<DetectorModelSummary> detectorModelSummaries() {
        return this.detectorModelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectorModelSummaries() ? this.detectorModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDetectorModelsResponse)) {
            return false;
        }
        ListDetectorModelsResponse other = (ListDetectorModelsResponse)((Object)obj);
        return this.hasDetectorModelSummaries() == other.hasDetectorModelSummaries() && Objects.equals(this.detectorModelSummaries(), other.detectorModelSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDetectorModelsResponse").add("DetectorModelSummaries", this.hasDetectorModelSummaries() ? this.detectorModelSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.detectorModelSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDetectorModelsResponse, T> g) {
        return obj -> g.apply((ListDetectorModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsResponse.BuilderImpl
    implements Builder {
        private List<DetectorModelSummary> detectorModelSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDetectorModelsResponse model) {
            super(model);
            this.detectorModelSummaries(model.detectorModelSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DetectorModelSummary.Builder> getDetectorModelSummaries() {
            List<DetectorModelSummary.Builder> result = DetectorModelSummariesCopier.copyToBuilder(this.detectorModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetectorModelSummaries(Collection<DetectorModelSummary.BuilderImpl> detectorModelSummaries) {
            this.detectorModelSummaries = DetectorModelSummariesCopier.copyFromBuilder(detectorModelSummaries);
        }

        @Override
        public final Builder detectorModelSummaries(Collection<DetectorModelSummary> detectorModelSummaries) {
            this.detectorModelSummaries = DetectorModelSummariesCopier.copy(detectorModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorModelSummaries(DetectorModelSummary ... detectorModelSummaries) {
            this.detectorModelSummaries(Arrays.asList(detectorModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorModelSummaries(Consumer<DetectorModelSummary.Builder> ... detectorModelSummaries) {
            this.detectorModelSummaries(Stream.of(detectorModelSummaries).map(c -> (DetectorModelSummary)((DetectorModelSummary.Builder)DetectorModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDetectorModelsResponse build() {
            return new ListDetectorModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDetectorModelsResponse> {
        public Builder detectorModelSummaries(Collection<DetectorModelSummary> var1);

        public Builder detectorModelSummaries(DetectorModelSummary ... var1);

        public Builder detectorModelSummaries(Consumer<DetectorModelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

