/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnalysisResultLevel {
    INFO("INFO"),
    WARNING("WARNING"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnalysisResultLevel> VALUE_MAP;
    private final String value;

    private AnalysisResultLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnalysisResultLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnalysisResultLevel> knownValues() {
        EnumSet<AnalysisResultLevel> knownValues = EnumSet.allOf(AnalysisResultLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnalysisResultLevel.class, AnalysisResultLevel::toString);
    }
}

