/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotevents.DefaultIotEventsAsyncClient;
import software.amazon.awssdk.services.iotevents.DefaultIotEventsBaseClientBuilder;
import software.amazon.awssdk.services.iotevents.IotEventsAsyncClient;
import software.amazon.awssdk.services.iotevents.IotEventsAsyncClientBuilder;
import software.amazon.awssdk.services.iotevents.IotEventsServiceClientConfiguration;
import software.amazon.awssdk.services.iotevents.endpoints.IotEventsEndpointProvider;

@SdkInternalApi
final class DefaultIotEventsAsyncClientBuilder
extends DefaultIotEventsBaseClientBuilder<IotEventsAsyncClientBuilder, IotEventsAsyncClient>
implements IotEventsAsyncClientBuilder {
    DefaultIotEventsAsyncClientBuilder() {
    }

    @Override
    public DefaultIotEventsAsyncClientBuilder endpointProvider(IotEventsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotEventsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIotEventsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        IotEventsServiceClientConfiguration serviceClientConfiguration = IotEventsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultIotEventsAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

