/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.EmailConfiguration;
import software.amazon.awssdk.services.iotevents.model.EmailConfigurationsCopier;
import software.amazon.awssdk.services.iotevents.model.NotificationTargetActions;
import software.amazon.awssdk.services.iotevents.model.SMSConfiguration;
import software.amazon.awssdk.services.iotevents.model.SMSConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationAction> {
    private static final SdkField<NotificationTargetActions> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("action").getter(NotificationAction.getter(NotificationAction::action)).setter(NotificationAction.setter(Builder::action)).constructor(NotificationTargetActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<List<SMSConfiguration>> SMS_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("smsConfigurations").getter(NotificationAction.getter(NotificationAction::smsConfigurations)).setter(NotificationAction.setter(Builder::smsConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smsConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SMSConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EmailConfiguration>> EMAIL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("emailConfigurations").getter(NotificationAction.getter(NotificationAction::emailConfigurations)).setter(NotificationAction.setter(Builder::emailConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, SMS_CONFIGURATIONS_FIELD, EMAIL_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final NotificationTargetActions action;
    private final List<SMSConfiguration> smsConfigurations;
    private final List<EmailConfiguration> emailConfigurations;

    private NotificationAction(BuilderImpl builder) {
        this.action = builder.action;
        this.smsConfigurations = builder.smsConfigurations;
        this.emailConfigurations = builder.emailConfigurations;
    }

    public final NotificationTargetActions action() {
        return this.action;
    }

    public final boolean hasSmsConfigurations() {
        return this.smsConfigurations != null && !(this.smsConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SMSConfiguration> smsConfigurations() {
        return this.smsConfigurations;
    }

    public final boolean hasEmailConfigurations() {
        return this.emailConfigurations != null && !(this.emailConfigurations instanceof SdkAutoConstructList);
    }

    public final List<EmailConfiguration> emailConfigurations() {
        return this.emailConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSmsConfigurations() ? this.smsConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmailConfigurations() ? this.emailConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationAction)) {
            return false;
        }
        NotificationAction other = (NotificationAction)obj;
        return Objects.equals(this.action(), other.action()) && this.hasSmsConfigurations() == other.hasSmsConfigurations() && Objects.equals(this.smsConfigurations(), other.smsConfigurations()) && this.hasEmailConfigurations() == other.hasEmailConfigurations() && Objects.equals(this.emailConfigurations(), other.emailConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationAction").add("Action", (Object)this.action()).add("SmsConfigurations", this.hasSmsConfigurations() ? this.smsConfigurations() : null).add("EmailConfigurations", this.hasEmailConfigurations() ? this.emailConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "smsConfigurations": {
                return Optional.ofNullable(clazz.cast(this.smsConfigurations()));
            }
            case "emailConfigurations": {
                return Optional.ofNullable(clazz.cast(this.emailConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationAction, T> g) {
        return obj -> g.apply((NotificationAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private NotificationTargetActions action;
        private List<SMSConfiguration> smsConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<EmailConfiguration> emailConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationAction model) {
            this.action(model.action);
            this.smsConfigurations(model.smsConfigurations);
            this.emailConfigurations(model.emailConfigurations);
        }

        public final NotificationTargetActions.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(NotificationTargetActions.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        @Transient
        public final Builder action(NotificationTargetActions action) {
            this.action = action;
            return this;
        }

        public final List<SMSConfiguration.Builder> getSmsConfigurations() {
            List<SMSConfiguration.Builder> result = SMSConfigurationsCopier.copyToBuilder(this.smsConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSmsConfigurations(Collection<SMSConfiguration.BuilderImpl> smsConfigurations) {
            this.smsConfigurations = SMSConfigurationsCopier.copyFromBuilder(smsConfigurations);
        }

        @Override
        @Transient
        public final Builder smsConfigurations(Collection<SMSConfiguration> smsConfigurations) {
            this.smsConfigurations = SMSConfigurationsCopier.copy(smsConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder smsConfigurations(SMSConfiguration ... smsConfigurations) {
            this.smsConfigurations(Arrays.asList(smsConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder smsConfigurations(Consumer<SMSConfiguration.Builder> ... smsConfigurations) {
            this.smsConfigurations(Stream.of(smsConfigurations).map(c -> (SMSConfiguration)((SMSConfiguration.Builder)SMSConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EmailConfiguration.Builder> getEmailConfigurations() {
            List<EmailConfiguration.Builder> result = EmailConfigurationsCopier.copyToBuilder(this.emailConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmailConfigurations(Collection<EmailConfiguration.BuilderImpl> emailConfigurations) {
            this.emailConfigurations = EmailConfigurationsCopier.copyFromBuilder(emailConfigurations);
        }

        @Override
        @Transient
        public final Builder emailConfigurations(Collection<EmailConfiguration> emailConfigurations) {
            this.emailConfigurations = EmailConfigurationsCopier.copy(emailConfigurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder emailConfigurations(EmailConfiguration ... emailConfigurations) {
            this.emailConfigurations(Arrays.asList(emailConfigurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder emailConfigurations(Consumer<EmailConfiguration.Builder> ... emailConfigurations) {
            this.emailConfigurations(Stream.of(emailConfigurations).map(c -> (EmailConfiguration)((EmailConfiguration.Builder)EmailConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NotificationAction build() {
            return new NotificationAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationAction> {
        public Builder action(NotificationTargetActions var1);

        default public Builder action(Consumer<NotificationTargetActions.Builder> action) {
            return this.action((NotificationTargetActions)((NotificationTargetActions.Builder)NotificationTargetActions.builder().applyMutation(action)).build());
        }

        public Builder smsConfigurations(Collection<SMSConfiguration> var1);

        public Builder smsConfigurations(SMSConfiguration ... var1);

        public Builder smsConfigurations(Consumer<SMSConfiguration.Builder> ... var1);

        public Builder emailConfigurations(Collection<EmailConfiguration> var1);

        public Builder emailConfigurations(EmailConfiguration ... var1);

        public Builder emailConfigurations(Consumer<EmailConfiguration.Builder> ... var1);
    }
}

