/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.AlarmModelSummariesCopier;
import software.amazon.awssdk.services.iotevents.model.AlarmModelSummary;
import software.amazon.awssdk.services.iotevents.model.IotEventsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAlarmModelsResponse
extends IotEventsResponse
implements ToCopyableBuilder<Builder, ListAlarmModelsResponse> {
    private static final SdkField<List<AlarmModelSummary>> ALARM_MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("alarmModelSummaries").getter(ListAlarmModelsResponse.getter(ListAlarmModelsResponse::alarmModelSummaries)).setter(ListAlarmModelsResponse.setter(Builder::alarmModelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlarmModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAlarmModelsResponse.getter(ListAlarmModelsResponse::nextToken)).setter(ListAlarmModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AlarmModelSummary> alarmModelSummaries;
    private final String nextToken;

    private ListAlarmModelsResponse(BuilderImpl builder) {
        super(builder);
        this.alarmModelSummaries = builder.alarmModelSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlarmModelSummaries() {
        return this.alarmModelSummaries != null && !(this.alarmModelSummaries instanceof SdkAutoConstructList);
    }

    public final List<AlarmModelSummary> alarmModelSummaries() {
        return this.alarmModelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmModelSummaries() ? this.alarmModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlarmModelsResponse)) {
            return false;
        }
        ListAlarmModelsResponse other = (ListAlarmModelsResponse)((Object)obj);
        return this.hasAlarmModelSummaries() == other.hasAlarmModelSummaries() && Objects.equals(this.alarmModelSummaries(), other.alarmModelSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAlarmModelsResponse").add("AlarmModelSummaries", this.hasAlarmModelSummaries() ? this.alarmModelSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.alarmModelSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAlarmModelsResponse, T> g) {
        return obj -> g.apply((ListAlarmModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsResponse.BuilderImpl
    implements Builder {
        private List<AlarmModelSummary> alarmModelSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlarmModelsResponse model) {
            super(model);
            this.alarmModelSummaries(model.alarmModelSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AlarmModelSummary.Builder> getAlarmModelSummaries() {
            List<AlarmModelSummary.Builder> result = AlarmModelSummariesCopier.copyToBuilder(this.alarmModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder alarmModelSummaries(Collection<AlarmModelSummary> alarmModelSummaries) {
            this.alarmModelSummaries = AlarmModelSummariesCopier.copy(alarmModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmModelSummaries(AlarmModelSummary ... alarmModelSummaries) {
            this.alarmModelSummaries(Arrays.asList(alarmModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmModelSummaries(Consumer<AlarmModelSummary.Builder> ... alarmModelSummaries) {
            this.alarmModelSummaries(Stream.of(alarmModelSummaries).map(c -> (AlarmModelSummary)((AlarmModelSummary.Builder)AlarmModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAlarmModelSummaries(Collection<AlarmModelSummary.BuilderImpl> alarmModelSummaries) {
            this.alarmModelSummaries = AlarmModelSummariesCopier.copyFromBuilder(alarmModelSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAlarmModelsResponse build() {
            return new ListAlarmModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAlarmModelsResponse> {
        public Builder alarmModelSummaries(Collection<AlarmModelSummary> var1);

        public Builder alarmModelSummaries(AlarmModelSummary ... var1);

        public Builder alarmModelSummaries(Consumer<AlarmModelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

