/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.AlarmModelVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmModelVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmModelVersionSummary> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelName").getter(AlarmModelVersionSummary.getter(AlarmModelVersionSummary::alarmModelName)).setter(AlarmModelVersionSummary.setter(Builder::alarmModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()}).build();
    private static final SdkField<String> ALARM_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelArn").getter(AlarmModelVersionSummary.getter(AlarmModelVersionSummary::alarmModelArn)).setter(AlarmModelVersionSummary.setter(Builder::alarmModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelArn").build()}).build();
    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelVersion").getter(AlarmModelVersionSummary.getter(AlarmModelVersionSummary::alarmModelVersion)).setter(AlarmModelVersionSummary.setter(Builder::alarmModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(AlarmModelVersionSummary.getter(AlarmModelVersionSummary::roleArn)).setter(AlarmModelVersionSummary.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AlarmModelVersionSummary.getter(AlarmModelVersionSummary::creationTime)).setter(AlarmModelVersionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(AlarmModelVersionSummary.getter(AlarmModelVersionSummary::lastUpdateTime)).setter(AlarmModelVersionSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AlarmModelVersionSummary.getter(AlarmModelVersionSummary::statusAsString)).setter(AlarmModelVersionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(AlarmModelVersionSummary.getter(AlarmModelVersionSummary::statusMessage)).setter(AlarmModelVersionSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD, ALARM_MODEL_ARN_FIELD, ALARM_MODEL_VERSION_FIELD, ROLE_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alarmModelName;
    private final String alarmModelArn;
    private final String alarmModelVersion;
    private final String roleArn;
    private final Instant creationTime;
    private final Instant lastUpdateTime;
    private final String status;
    private final String statusMessage;

    private AlarmModelVersionSummary(BuilderImpl builder) {
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelArn = builder.alarmModelArn;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.roleArn = builder.roleArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String alarmModelName() {
        return this.alarmModelName;
    }

    public final String alarmModelArn() {
        return this.alarmModelArn;
    }

    public final String alarmModelVersion() {
        return this.alarmModelVersion;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final AlarmModelVersionStatus status() {
        return AlarmModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmModelVersionSummary)) {
            return false;
        }
        AlarmModelVersionSummary other = (AlarmModelVersionSummary)obj;
        return Objects.equals(this.alarmModelName(), other.alarmModelName()) && Objects.equals(this.alarmModelArn(), other.alarmModelArn()) && Objects.equals(this.alarmModelVersion(), other.alarmModelVersion()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmModelVersionSummary").add("AlarmModelName", (Object)this.alarmModelName()).add("AlarmModelArn", (Object)this.alarmModelArn()).add("AlarmModelVersion", (Object)this.alarmModelVersion()).add("RoleArn", (Object)this.roleArn()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmModelName": {
                return Optional.ofNullable(clazz.cast(this.alarmModelName()));
            }
            case "alarmModelArn": {
                return Optional.ofNullable(clazz.cast(this.alarmModelArn()));
            }
            case "alarmModelVersion": {
                return Optional.ofNullable(clazz.cast(this.alarmModelVersion()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmModelVersionSummary, T> g) {
        return obj -> g.apply((AlarmModelVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmModelName;
        private String alarmModelArn;
        private String alarmModelVersion;
        private String roleArn;
        private Instant creationTime;
        private Instant lastUpdateTime;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmModelVersionSummary model) {
            this.alarmModelName(model.alarmModelName);
            this.alarmModelArn(model.alarmModelArn);
            this.alarmModelVersion(model.alarmModelVersion);
            this.roleArn(model.roleArn);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getAlarmModelName() {
            return this.alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        public final String getAlarmModelArn() {
            return this.alarmModelArn;
        }

        @Override
        public final Builder alarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
            return this;
        }

        public final void setAlarmModelArn(String alarmModelArn) {
            this.alarmModelArn = alarmModelArn;
        }

        public final String getAlarmModelVersion() {
            return this.alarmModelVersion;
        }

        @Override
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AlarmModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public AlarmModelVersionSummary build() {
            return new AlarmModelVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmModelVersionSummary> {
        public Builder alarmModelName(String var1);

        public Builder alarmModelArn(String var1);

        public Builder alarmModelVersion(String var1);

        public Builder roleArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(AlarmModelVersionStatus var1);

        public Builder statusMessage(String var1);
    }
}

