/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.AssetPropertyValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotSiteWiseAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IotSiteWiseAction> {
    private static final SdkField<String> ENTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entryId").getter(IotSiteWiseAction.getter(IotSiteWiseAction::entryId)).setter(IotSiteWiseAction.setter(Builder::entryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryId").build()}).build();
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(IotSiteWiseAction.getter(IotSiteWiseAction::assetId)).setter(IotSiteWiseAction.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(IotSiteWiseAction.getter(IotSiteWiseAction::propertyId)).setter(IotSiteWiseAction.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyId").build()}).build();
    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyAlias").getter(IotSiteWiseAction.getter(IotSiteWiseAction::propertyAlias)).setter(IotSiteWiseAction.setter(Builder::propertyAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyAlias").build()}).build();
    private static final SdkField<AssetPropertyValue> PROPERTY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("propertyValue").getter(IotSiteWiseAction.getter(IotSiteWiseAction::propertyValue)).setter(IotSiteWiseAction.setter(Builder::propertyValue)).constructor(AssetPropertyValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_ID_FIELD, ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, PROPERTY_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String entryId;
    private final String assetId;
    private final String propertyId;
    private final String propertyAlias;
    private final AssetPropertyValue propertyValue;

    private IotSiteWiseAction(BuilderImpl builder) {
        this.entryId = builder.entryId;
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.propertyValue = builder.propertyValue;
    }

    public final String entryId() {
        return this.entryId;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    public final String propertyAlias() {
        return this.propertyAlias;
    }

    public final AssetPropertyValue propertyValue() {
        return this.propertyValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotSiteWiseAction)) {
            return false;
        }
        IotSiteWiseAction other = (IotSiteWiseAction)obj;
        return Objects.equals(this.entryId(), other.entryId()) && Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.propertyAlias(), other.propertyAlias()) && Objects.equals(this.propertyValue(), other.propertyValue());
    }

    public final String toString() {
        return ToString.builder((String)"IotSiteWiseAction").add("EntryId", (Object)this.entryId()).add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("PropertyAlias", (Object)this.propertyAlias()).add("PropertyValue", (Object)this.propertyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryId": {
                return Optional.ofNullable(clazz.cast(this.entryId()));
            }
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "propertyAlias": {
                return Optional.ofNullable(clazz.cast(this.propertyAlias()));
            }
            case "propertyValue": {
                return Optional.ofNullable(clazz.cast(this.propertyValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotSiteWiseAction, T> g) {
        return obj -> g.apply((IotSiteWiseAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String entryId;
        private String assetId;
        private String propertyId;
        private String propertyAlias;
        private AssetPropertyValue propertyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(IotSiteWiseAction model) {
            this.entryId(model.entryId);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.propertyAlias(model.propertyAlias);
            this.propertyValue(model.propertyValue);
        }

        public final String getEntryId() {
            return this.entryId;
        }

        @Override
        public final Builder entryId(String entryId) {
            this.entryId = entryId;
            return this;
        }

        public final void setEntryId(String entryId) {
            this.entryId = entryId;
        }

        public final String getAssetId() {
            return this.assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        public final String getPropertyAlias() {
            return this.propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        public final AssetPropertyValue.Builder getPropertyValue() {
            return this.propertyValue != null ? this.propertyValue.toBuilder() : null;
        }

        @Override
        public final Builder propertyValue(AssetPropertyValue propertyValue) {
            this.propertyValue = propertyValue;
            return this;
        }

        public final void setPropertyValue(AssetPropertyValue.BuilderImpl propertyValue) {
            this.propertyValue = propertyValue != null ? propertyValue.build() : null;
        }

        public IotSiteWiseAction build() {
            return new IotSiteWiseAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IotSiteWiseAction> {
        public Builder entryId(String var1);

        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder propertyAlias(String var1);

        public Builder propertyValue(AssetPropertyValue var1);

        default public Builder propertyValue(Consumer<AssetPropertyValue.Builder> propertyValue) {
            return this.propertyValue((AssetPropertyValue)((AssetPropertyValue.Builder)AssetPropertyValue.builder().applyMutation(propertyValue)).build());
        }
    }
}

