/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorModelSummary> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelName").getter(DetectorModelSummary.getter(DetectorModelSummary::detectorModelName)).setter(DetectorModelSummary.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorModelDescription").getter(DetectorModelSummary.getter(DetectorModelSummary::detectorModelDescription)).setter(DetectorModelSummary.setter(Builder::detectorModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDescription").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(DetectorModelSummary.getter(DetectorModelSummary::creationTime)).setter(DetectorModelSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, DETECTOR_MODEL_DESCRIPTION_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String detectorModelName;
    private final String detectorModelDescription;
    private final Instant creationTime;

    private DetectorModelSummary(BuilderImpl builder) {
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelDescription = builder.detectorModelDescription;
        this.creationTime = builder.creationTime;
    }

    public String detectorModelName() {
        return this.detectorModelName;
    }

    public String detectorModelDescription() {
        return this.detectorModelDescription;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelSummary)) {
            return false;
        }
        DetectorModelSummary other = (DetectorModelSummary)obj;
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.detectorModelDescription(), other.detectorModelDescription()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public String toString() {
        return ToString.builder((String)"DetectorModelSummary").add("DetectorModelName", (Object)this.detectorModelName()).add("DetectorModelDescription", (Object)this.detectorModelDescription()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "detectorModelDescription": {
                return Optional.ofNullable(clazz.cast(this.detectorModelDescription()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelSummary, T> g) {
        return obj -> g.apply((DetectorModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detectorModelName;
        private String detectorModelDescription;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelSummary model) {
            this.detectorModelName(model.detectorModelName);
            this.detectorModelDescription(model.detectorModelDescription);
            this.creationTime(model.creationTime);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final String getDetectorModelDescription() {
            return this.detectorModelDescription;
        }

        @Override
        public final Builder detectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
            return this;
        }

        public final void setDetectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public DetectorModelSummary build() {
            return new DetectorModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorModelSummary> {
        public Builder detectorModelName(String var1);

        public Builder detectorModelDescription(String var1);

        public Builder creationTime(Instant var1);
    }
}

