/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotevents.model.IotEventsException;
import software.amazon.awssdk.services.iotevents.model.TagrisStatus;
import software.amazon.awssdk.services.iotevents.model.TagrisSweepListResultCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagrisPartialResourcesExistResultsException
extends IotEventsException
implements ToCopyableBuilder<Builder, TagrisPartialResourcesExistResultsException> {
    private static final SdkField<Map<String, String>> RESOURCE_EXISTENCE_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(TagrisPartialResourcesExistResultsException.getter(TagrisPartialResourcesExistResultsException::resourceExistenceInformationAsStrings)).setter(TagrisPartialResourcesExistResultsException.setter(Builder::resourceExistenceInformationWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceExistenceInformation").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_EXISTENCE_INFORMATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> resourceExistenceInformation;

    private TagrisPartialResourcesExistResultsException(BuilderImpl builder) {
        super(builder);
        this.resourceExistenceInformation = builder.resourceExistenceInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public Map<String, TagrisStatus> resourceExistenceInformation() {
        return TagrisSweepListResultCopier.copyStringToEnum(this.resourceExistenceInformation);
    }

    public boolean hasResourceExistenceInformation() {
        return this.resourceExistenceInformation != null && !(this.resourceExistenceInformation instanceof SdkAutoConstructMap);
    }

    public Map<String, String> resourceExistenceInformationAsStrings() {
        return this.resourceExistenceInformation;
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagrisPartialResourcesExistResultsException, T> g) {
        return obj -> g.apply((TagrisPartialResourcesExistResultsException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsException.BuilderImpl
    implements Builder {
        private Map<String, String> resourceExistenceInformation = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagrisPartialResourcesExistResultsException model) {
            super(model);
            this.resourceExistenceInformationWithStrings(model.resourceExistenceInformation);
        }

        public final Map<String, String> getResourceExistenceInformation() {
            return this.resourceExistenceInformation;
        }

        @Override
        public final Builder resourceExistenceInformationWithStrings(Map<String, String> resourceExistenceInformation) {
            this.resourceExistenceInformation = TagrisSweepListResultCopier.copy(resourceExistenceInformation);
            return this;
        }

        @Override
        public final Builder resourceExistenceInformation(Map<String, TagrisStatus> resourceExistenceInformation) {
            this.resourceExistenceInformation = TagrisSweepListResultCopier.copyEnumToString(resourceExistenceInformation);
            return this;
        }

        public final void setResourceExistenceInformation(Map<String, String> resourceExistenceInformation) {
            this.resourceExistenceInformation = TagrisSweepListResultCopier.copy(resourceExistenceInformation);
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public TagrisPartialResourcesExistResultsException build() {
            return new TagrisPartialResourcesExistResultsException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TagrisPartialResourcesExistResultsException>,
    IotEventsException.Builder {
        public Builder resourceExistenceInformationWithStrings(Map<String, String> var1);

        public Builder resourceExistenceInformation(Map<String, TagrisStatus> var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

