/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.State;
import software.amazon.awssdk.services.iotevents.model.StatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorModelDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorModelDefinition> {
    private static final SdkField<List<State>> STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectorModelDefinition.getter(DetectorModelDefinition::states)).setter(DetectorModelDefinition.setter(Builder::states)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("states").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(State::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INITIAL_STATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectorModelDefinition.getter(DetectorModelDefinition::initialStateName)).setter(DetectorModelDefinition.setter(Builder::initialStateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialStateName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATES_FIELD, INITIAL_STATE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<State> states;
    private final String initialStateName;

    private DetectorModelDefinition(BuilderImpl builder) {
        this.states = builder.states;
        this.initialStateName = builder.initialStateName;
    }

    public boolean hasStates() {
        return this.states != null && !(this.states instanceof SdkAutoConstructList);
    }

    public List<State> states() {
        return this.states;
    }

    public String initialStateName() {
        return this.initialStateName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.states());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialStateName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorModelDefinition)) {
            return false;
        }
        DetectorModelDefinition other = (DetectorModelDefinition)obj;
        return Objects.equals(this.states(), other.states()) && Objects.equals(this.initialStateName(), other.initialStateName());
    }

    public String toString() {
        return ToString.builder((String)"DetectorModelDefinition").add("States", this.states()).add("InitialStateName", (Object)this.initialStateName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "states": {
                return Optional.ofNullable(clazz.cast(this.states()));
            }
            case "initialStateName": {
                return Optional.ofNullable(clazz.cast(this.initialStateName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorModelDefinition, T> g) {
        return obj -> g.apply((DetectorModelDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<State> states = DefaultSdkAutoConstructList.getInstance();
        private String initialStateName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorModelDefinition model) {
            this.states(model.states);
            this.initialStateName(model.initialStateName);
        }

        public final Collection<State.Builder> getStates() {
            return this.states != null ? (Collection)this.states.stream().map(State::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder states(Collection<State> states) {
            this.states = StatesCopier.copy(states);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(State ... states) {
            this.states(Arrays.asList(states));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder states(Consumer<State.Builder> ... states) {
            this.states(Stream.of(states).map(c -> (State)((State.Builder)State.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStates(Collection<State.BuilderImpl> states) {
            this.states = StatesCopier.copyFromBuilder(states);
        }

        public final String getInitialStateName() {
            return this.initialStateName;
        }

        @Override
        public final Builder initialStateName(String initialStateName) {
            this.initialStateName = initialStateName;
            return this;
        }

        public final void setInitialStateName(String initialStateName) {
            this.initialStateName = initialStateName;
        }

        public DetectorModelDefinition build() {
            return new DetectorModelDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorModelDefinition> {
        public Builder states(Collection<State> var1);

        public Builder states(State ... var1);

        public Builder states(Consumer<State.Builder> ... var1);

        public Builder initialStateName(String var1);
    }
}

