/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.Payload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamoDBAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamoDBAction> {
    private static final SdkField<String> HASH_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::hashKeyType)).setter(DynamoDBAction.setter(Builder::hashKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashKeyType").build()}).build();
    private static final SdkField<String> HASH_KEY_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::hashKeyField)).setter(DynamoDBAction.setter(Builder::hashKeyField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashKeyField").build()}).build();
    private static final SdkField<String> HASH_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::hashKeyValue)).setter(DynamoDBAction.setter(Builder::hashKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashKeyValue").build()}).build();
    private static final SdkField<String> RANGE_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::rangeKeyType)).setter(DynamoDBAction.setter(Builder::rangeKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rangeKeyType").build()}).build();
    private static final SdkField<String> RANGE_KEY_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::rangeKeyField)).setter(DynamoDBAction.setter(Builder::rangeKeyField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rangeKeyField").build()}).build();
    private static final SdkField<String> RANGE_KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::rangeKeyValue)).setter(DynamoDBAction.setter(Builder::rangeKeyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rangeKeyValue").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::operation)).setter(DynamoDBAction.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<String> PAYLOAD_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::payloadField)).setter(DynamoDBAction.setter(Builder::payloadField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadField").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DynamoDBAction.getter(DynamoDBAction::tableName)).setter(DynamoDBAction.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final SdkField<Payload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DynamoDBAction.getter(DynamoDBAction::payload)).setter(DynamoDBAction.setter(Builder::payload)).constructor(Payload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HASH_KEY_TYPE_FIELD, HASH_KEY_FIELD_FIELD, HASH_KEY_VALUE_FIELD, RANGE_KEY_TYPE_FIELD, RANGE_KEY_FIELD_FIELD, RANGE_KEY_VALUE_FIELD, OPERATION_FIELD, PAYLOAD_FIELD_FIELD, TABLE_NAME_FIELD, PAYLOAD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hashKeyType;
    private final String hashKeyField;
    private final String hashKeyValue;
    private final String rangeKeyType;
    private final String rangeKeyField;
    private final String rangeKeyValue;
    private final String operation;
    private final String payloadField;
    private final String tableName;
    private final Payload payload;

    private DynamoDBAction(BuilderImpl builder) {
        this.hashKeyType = builder.hashKeyType;
        this.hashKeyField = builder.hashKeyField;
        this.hashKeyValue = builder.hashKeyValue;
        this.rangeKeyType = builder.rangeKeyType;
        this.rangeKeyField = builder.rangeKeyField;
        this.rangeKeyValue = builder.rangeKeyValue;
        this.operation = builder.operation;
        this.payloadField = builder.payloadField;
        this.tableName = builder.tableName;
        this.payload = builder.payload;
    }

    public String hashKeyType() {
        return this.hashKeyType;
    }

    public String hashKeyField() {
        return this.hashKeyField;
    }

    public String hashKeyValue() {
        return this.hashKeyValue;
    }

    public String rangeKeyType() {
        return this.rangeKeyType;
    }

    public String rangeKeyField() {
        return this.rangeKeyField;
    }

    public String rangeKeyValue() {
        return this.rangeKeyValue;
    }

    public String operation() {
        return this.operation;
    }

    public String payloadField() {
        return this.payloadField;
    }

    public String tableName() {
        return this.tableName;
    }

    public Payload payload() {
        return this.payload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyType());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyField());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeKeyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadField());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamoDBAction)) {
            return false;
        }
        DynamoDBAction other = (DynamoDBAction)obj;
        return Objects.equals(this.hashKeyType(), other.hashKeyType()) && Objects.equals(this.hashKeyField(), other.hashKeyField()) && Objects.equals(this.hashKeyValue(), other.hashKeyValue()) && Objects.equals(this.rangeKeyType(), other.rangeKeyType()) && Objects.equals(this.rangeKeyField(), other.rangeKeyField()) && Objects.equals(this.rangeKeyValue(), other.rangeKeyValue()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.payloadField(), other.payloadField()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        return ToString.builder((String)"DynamoDBAction").add("HashKeyType", (Object)this.hashKeyType()).add("HashKeyField", (Object)this.hashKeyField()).add("HashKeyValue", (Object)this.hashKeyValue()).add("RangeKeyType", (Object)this.rangeKeyType()).add("RangeKeyField", (Object)this.rangeKeyField()).add("RangeKeyValue", (Object)this.rangeKeyValue()).add("Operation", (Object)this.operation()).add("PayloadField", (Object)this.payloadField()).add("TableName", (Object)this.tableName()).add("Payload", (Object)this.payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hashKeyType": {
                return Optional.ofNullable(clazz.cast(this.hashKeyType()));
            }
            case "hashKeyField": {
                return Optional.ofNullable(clazz.cast(this.hashKeyField()));
            }
            case "hashKeyValue": {
                return Optional.ofNullable(clazz.cast(this.hashKeyValue()));
            }
            case "rangeKeyType": {
                return Optional.ofNullable(clazz.cast(this.rangeKeyType()));
            }
            case "rangeKeyField": {
                return Optional.ofNullable(clazz.cast(this.rangeKeyField()));
            }
            case "rangeKeyValue": {
                return Optional.ofNullable(clazz.cast(this.rangeKeyValue()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "payloadField": {
                return Optional.ofNullable(clazz.cast(this.payloadField()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamoDBAction, T> g) {
        return obj -> g.apply((DynamoDBAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hashKeyType;
        private String hashKeyField;
        private String hashKeyValue;
        private String rangeKeyType;
        private String rangeKeyField;
        private String rangeKeyValue;
        private String operation;
        private String payloadField;
        private String tableName;
        private Payload payload;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamoDBAction model) {
            this.hashKeyType(model.hashKeyType);
            this.hashKeyField(model.hashKeyField);
            this.hashKeyValue(model.hashKeyValue);
            this.rangeKeyType(model.rangeKeyType);
            this.rangeKeyField(model.rangeKeyField);
            this.rangeKeyValue(model.rangeKeyValue);
            this.operation(model.operation);
            this.payloadField(model.payloadField);
            this.tableName(model.tableName);
            this.payload(model.payload);
        }

        public final String getHashKeyType() {
            return this.hashKeyType;
        }

        @Override
        public final Builder hashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
            return this;
        }

        public final void setHashKeyType(String hashKeyType) {
            this.hashKeyType = hashKeyType;
        }

        public final String getHashKeyField() {
            return this.hashKeyField;
        }

        @Override
        public final Builder hashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
            return this;
        }

        public final void setHashKeyField(String hashKeyField) {
            this.hashKeyField = hashKeyField;
        }

        public final String getHashKeyValue() {
            return this.hashKeyValue;
        }

        @Override
        public final Builder hashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
            return this;
        }

        public final void setHashKeyValue(String hashKeyValue) {
            this.hashKeyValue = hashKeyValue;
        }

        public final String getRangeKeyType() {
            return this.rangeKeyType;
        }

        @Override
        public final Builder rangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
            return this;
        }

        public final void setRangeKeyType(String rangeKeyType) {
            this.rangeKeyType = rangeKeyType;
        }

        public final String getRangeKeyField() {
            return this.rangeKeyField;
        }

        @Override
        public final Builder rangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
            return this;
        }

        public final void setRangeKeyField(String rangeKeyField) {
            this.rangeKeyField = rangeKeyField;
        }

        public final String getRangeKeyValue() {
            return this.rangeKeyValue;
        }

        @Override
        public final Builder rangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
            return this;
        }

        public final void setRangeKeyValue(String rangeKeyValue) {
            this.rangeKeyValue = rangeKeyValue;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getPayloadField() {
            return this.payloadField;
        }

        @Override
        public final Builder payloadField(String payloadField) {
            this.payloadField = payloadField;
            return this;
        }

        public final void setPayloadField(String payloadField) {
            this.payloadField = payloadField;
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Payload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        @Override
        public final Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public final void setPayload(Payload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        public DynamoDBAction build() {
            return new DynamoDBAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamoDBAction> {
        public Builder hashKeyType(String var1);

        public Builder hashKeyField(String var1);

        public Builder hashKeyValue(String var1);

        public Builder rangeKeyType(String var1);

        public Builder rangeKeyField(String var1);

        public Builder rangeKeyValue(String var1);

        public Builder operation(String var1);

        public Builder payloadField(String var1);

        public Builder tableName(String var1);

        public Builder payload(Payload var1);

        default public Builder payload(Consumer<Payload.Builder> payload) {
            return this.payload((Payload)((Payload.Builder)Payload.builder().applyMutation(payload)).build());
        }
    }
}

