/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotevents.model.Payload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotEventsAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IotEventsAction> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IotEventsAction.getter(IotEventsAction::inputName)).setter(IotEventsAction.setter(Builder::inputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()}).build();
    private static final SdkField<Payload> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(IotEventsAction.getter(IotEventsAction::payload)).setter(IotEventsAction.setter(Builder::payload)).constructor(Payload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD, PAYLOAD_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputName;
    private final Payload payload;

    private IotEventsAction(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.payload = builder.payload;
    }

    public String inputName() {
        return this.inputName;
    }

    public Payload payload() {
        return this.payload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotEventsAction)) {
            return false;
        }
        IotEventsAction other = (IotEventsAction)obj;
        return Objects.equals(this.inputName(), other.inputName()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        return ToString.builder((String)"IotEventsAction").add("InputName", (Object)this.inputName()).add("Payload", (Object)this.payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputName": {
                return Optional.ofNullable(clazz.cast(this.inputName()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotEventsAction, T> g) {
        return obj -> g.apply((IotEventsAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputName;
        private Payload payload;

        private BuilderImpl() {
        }

        private BuilderImpl(IotEventsAction model) {
            this.inputName(model.inputName);
            this.payload(model.payload);
        }

        public final String getInputName() {
            return this.inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        public final Payload.Builder getPayload() {
            return this.payload != null ? this.payload.toBuilder() : null;
        }

        @Override
        public final Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public final void setPayload(Payload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        public IotEventsAction build() {
            return new IotEventsAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IotEventsAction> {
        public Builder inputName(String var1);

        public Builder payload(Payload var1);

        default public Builder payload(Consumer<Payload.Builder> payload) {
            return this.payload((Payload)((Payload.Builder)Payload.builder().applyMutation(payload)).build());
        }
    }
}

