/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotevents.model.IotEventsResponse;
import software.amazon.awssdk.services.iotevents.model.TagrisStatus;
import software.amazon.awssdk.services.iotevents.model.TagrisSweepListResultCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyResourcesExistForTagrisResponse
extends IotEventsResponse
implements ToCopyableBuilder<Builder, VerifyResourcesExistForTagrisResponse> {
    private static final SdkField<Map<String, String>> TAGRIS_SWEEP_LIST_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(VerifyResourcesExistForTagrisResponse.getter(VerifyResourcesExistForTagrisResponse::tagrisSweepListResultAsStrings)).setter(VerifyResourcesExistForTagrisResponse.setter(Builder::tagrisSweepListResultWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagrisSweepListResult").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGRIS_SWEEP_LIST_RESULT_FIELD));
    private final Map<String, String> tagrisSweepListResult;

    private VerifyResourcesExistForTagrisResponse(BuilderImpl builder) {
        super(builder);
        this.tagrisSweepListResult = builder.tagrisSweepListResult;
    }

    public Map<String, TagrisStatus> tagrisSweepListResult() {
        return TagrisSweepListResultCopier.copyStringToEnum(this.tagrisSweepListResult);
    }

    public boolean hasTagrisSweepListResult() {
        return this.tagrisSweepListResult != null && !(this.tagrisSweepListResult instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tagrisSweepListResultAsStrings() {
        return this.tagrisSweepListResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tagrisSweepListResultAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyResourcesExistForTagrisResponse)) {
            return false;
        }
        VerifyResourcesExistForTagrisResponse other = (VerifyResourcesExistForTagrisResponse)((Object)obj);
        return Objects.equals(this.tagrisSweepListResultAsStrings(), other.tagrisSweepListResultAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"VerifyResourcesExistForTagrisResponse").add("TagrisSweepListResult", this.tagrisSweepListResultAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagrisSweepListResult": {
                return Optional.ofNullable(clazz.cast(this.tagrisSweepListResultAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyResourcesExistForTagrisResponse, T> g) {
        return obj -> g.apply((VerifyResourcesExistForTagrisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsResponse.BuilderImpl
    implements Builder {
        private Map<String, String> tagrisSweepListResult = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyResourcesExistForTagrisResponse model) {
            super(model);
            this.tagrisSweepListResultWithStrings(model.tagrisSweepListResult);
        }

        public final Map<String, String> getTagrisSweepListResultAsStrings() {
            return this.tagrisSweepListResult;
        }

        @Override
        public final Builder tagrisSweepListResultWithStrings(Map<String, String> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copy(tagrisSweepListResult);
            return this;
        }

        @Override
        public final Builder tagrisSweepListResult(Map<String, TagrisStatus> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copyEnumToString(tagrisSweepListResult);
            return this;
        }

        public final void setTagrisSweepListResultWithStrings(Map<String, String> tagrisSweepListResult) {
            this.tagrisSweepListResult = TagrisSweepListResultCopier.copy(tagrisSweepListResult);
        }

        @Override
        public VerifyResourcesExistForTagrisResponse build() {
            return new VerifyResourcesExistForTagrisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyResourcesExistForTagrisResponse> {
        public Builder tagrisSweepListResultWithStrings(Map<String, String> var1);

        public Builder tagrisSweepListResult(Map<String, TagrisStatus> var1);
    }
}

