/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotevents.model.DetectorModelDefinition;
import software.amazon.awssdk.services.iotevents.model.EvaluationMethod;
import software.amazon.awssdk.services.iotevents.model.IotEventsRequest;
import software.amazon.awssdk.services.iotevents.model.Tag;
import software.amazon.awssdk.services.iotevents.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDetectorModelRequest
extends IotEventsRequest
implements ToCopyableBuilder<Builder, CreateDetectorModelRequest> {
    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDetectorModelRequest.getter(CreateDetectorModelRequest::detectorModelName)).setter(CreateDetectorModelRequest.setter(Builder::detectorModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()}).build();
    private static final SdkField<DetectorModelDefinition> DETECTOR_MODEL_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateDetectorModelRequest.getter(CreateDetectorModelRequest::detectorModelDefinition)).setter(CreateDetectorModelRequest.setter(Builder::detectorModelDefinition)).constructor(DetectorModelDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDefinition").build()}).build();
    private static final SdkField<String> DETECTOR_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDetectorModelRequest.getter(CreateDetectorModelRequest::detectorModelDescription)).setter(CreateDetectorModelRequest.setter(Builder::detectorModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelDescription").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDetectorModelRequest.getter(CreateDetectorModelRequest::key)).setter(CreateDetectorModelRequest.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDetectorModelRequest.getter(CreateDetectorModelRequest::roleArn)).setter(CreateDetectorModelRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDetectorModelRequest.getter(CreateDetectorModelRequest::tags)).setter(CreateDetectorModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDetectorModelRequest.getter(CreateDetectorModelRequest::evaluationMethodAsString)).setter(CreateDetectorModelRequest.setter(Builder::evaluationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_MODEL_NAME_FIELD, DETECTOR_MODEL_DEFINITION_FIELD, DETECTOR_MODEL_DESCRIPTION_FIELD, KEY_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, EVALUATION_METHOD_FIELD));
    private final String detectorModelName;
    private final DetectorModelDefinition detectorModelDefinition;
    private final String detectorModelDescription;
    private final String key;
    private final String roleArn;
    private final List<Tag> tags;
    private final String evaluationMethod;

    private CreateDetectorModelRequest(BuilderImpl builder) {
        super(builder);
        this.detectorModelName = builder.detectorModelName;
        this.detectorModelDefinition = builder.detectorModelDefinition;
        this.detectorModelDescription = builder.detectorModelDescription;
        this.key = builder.key;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.evaluationMethod = builder.evaluationMethod;
    }

    public String detectorModelName() {
        return this.detectorModelName;
    }

    public DetectorModelDefinition detectorModelDefinition() {
        return this.detectorModelDefinition;
    }

    public String detectorModelDescription() {
        return this.detectorModelDescription;
    }

    public String key() {
        return this.key;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public EvaluationMethod evaluationMethod() {
        return EvaluationMethod.fromValue(this.evaluationMethod);
    }

    public String evaluationMethodAsString() {
        return this.evaluationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMethodAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDetectorModelRequest)) {
            return false;
        }
        CreateDetectorModelRequest other = (CreateDetectorModelRequest)((Object)obj);
        return Objects.equals(this.detectorModelName(), other.detectorModelName()) && Objects.equals(this.detectorModelDefinition(), other.detectorModelDefinition()) && Objects.equals(this.detectorModelDescription(), other.detectorModelDescription()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.evaluationMethodAsString(), other.evaluationMethodAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateDetectorModelRequest").add("DetectorModelName", (Object)this.detectorModelName()).add("DetectorModelDefinition", (Object)this.detectorModelDefinition()).add("DetectorModelDescription", (Object)this.detectorModelDescription()).add("Key", (Object)this.key()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.tags()).add("EvaluationMethod", (Object)this.evaluationMethodAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorModelName": {
                return Optional.ofNullable(clazz.cast(this.detectorModelName()));
            }
            case "detectorModelDefinition": {
                return Optional.ofNullable(clazz.cast(this.detectorModelDefinition()));
            }
            case "detectorModelDescription": {
                return Optional.ofNullable(clazz.cast(this.detectorModelDescription()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "evaluationMethod": {
                return Optional.ofNullable(clazz.cast(this.evaluationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDetectorModelRequest, T> g) {
        return obj -> g.apply((CreateDetectorModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsRequest.BuilderImpl
    implements Builder {
        private String detectorModelName;
        private DetectorModelDefinition detectorModelDefinition;
        private String detectorModelDescription;
        private String key;
        private String roleArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String evaluationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDetectorModelRequest model) {
            super(model);
            this.detectorModelName(model.detectorModelName);
            this.detectorModelDefinition(model.detectorModelDefinition);
            this.detectorModelDescription(model.detectorModelDescription);
            this.key(model.key);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.evaluationMethod(model.evaluationMethod);
        }

        public final String getDetectorModelName() {
            return this.detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final DetectorModelDefinition.Builder getDetectorModelDefinition() {
            return this.detectorModelDefinition != null ? this.detectorModelDefinition.toBuilder() : null;
        }

        @Override
        public final Builder detectorModelDefinition(DetectorModelDefinition detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition;
            return this;
        }

        public final void setDetectorModelDefinition(DetectorModelDefinition.BuilderImpl detectorModelDefinition) {
            this.detectorModelDefinition = detectorModelDefinition != null ? detectorModelDefinition.build() : null;
        }

        public final String getDetectorModelDescription() {
            return this.detectorModelDescription;
        }

        @Override
        public final Builder detectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
            return this;
        }

        public final void setDetectorModelDescription(String detectorModelDescription) {
            this.detectorModelDescription = detectorModelDescription;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getEvaluationMethodAsString() {
            return this.evaluationMethod;
        }

        @Override
        public final Builder evaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
            return this;
        }

        @Override
        public final Builder evaluationMethod(EvaluationMethod evaluationMethod) {
            this.evaluationMethod(evaluationMethod == null ? null : evaluationMethod.toString());
            return this;
        }

        public final void setEvaluationMethod(String evaluationMethod) {
            this.evaluationMethod = evaluationMethod;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDetectorModelRequest build() {
            return new CreateDetectorModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDetectorModelRequest> {
        public Builder detectorModelName(String var1);

        public Builder detectorModelDefinition(DetectorModelDefinition var1);

        default public Builder detectorModelDefinition(Consumer<DetectorModelDefinition.Builder> detectorModelDefinition) {
            return this.detectorModelDefinition((DetectorModelDefinition)((DetectorModelDefinition.Builder)DetectorModelDefinition.builder().applyMutation(detectorModelDefinition)).build());
        }

        public Builder detectorModelDescription(String var1);

        public Builder key(String var1);

        public Builder roleArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder evaluationMethod(String var1);

        public Builder evaluationMethod(EvaluationMethod var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

