/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SelectedTestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuiteRunConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuiteRunConfiguration> {
    private static final SdkField<DeviceUnderTest> PRIMARY_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryDevice").getter(SuiteRunConfiguration.getter(SuiteRunConfiguration::primaryDevice)).setter(SuiteRunConfiguration.setter(Builder::primaryDevice)).constructor(DeviceUnderTest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryDevice").build()}).build();
    private static final SdkField<List<String>> SELECTED_TEST_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectedTestList").getter(SuiteRunConfiguration.getter(SuiteRunConfiguration::selectedTestList)).setter(SuiteRunConfiguration.setter(Builder::selectedTestList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedTestList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PARALLEL_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("parallelRun").getter(SuiteRunConfiguration.getter(SuiteRunConfiguration::parallelRun)).setter(SuiteRunConfiguration.setter(Builder::parallelRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_DEVICE_FIELD, SELECTED_TEST_LIST_FIELD, PARALLEL_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SuiteRunConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DeviceUnderTest primaryDevice;
    private final List<String> selectedTestList;
    private final Boolean parallelRun;

    private SuiteRunConfiguration(BuilderImpl builder) {
        this.primaryDevice = builder.primaryDevice;
        this.selectedTestList = builder.selectedTestList;
        this.parallelRun = builder.parallelRun;
    }

    public final DeviceUnderTest primaryDevice() {
        return this.primaryDevice;
    }

    public final boolean hasSelectedTestList() {
        return this.selectedTestList != null && !(this.selectedTestList instanceof SdkAutoConstructList);
    }

    public final List<String> selectedTestList() {
        return this.selectedTestList;
    }

    public final Boolean parallelRun() {
        return this.parallelRun;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedTestList() ? this.selectedTestList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteRunConfiguration)) {
            return false;
        }
        SuiteRunConfiguration other = (SuiteRunConfiguration)obj;
        return Objects.equals(this.primaryDevice(), other.primaryDevice()) && this.hasSelectedTestList() == other.hasSelectedTestList() && Objects.equals(this.selectedTestList(), other.selectedTestList()) && Objects.equals(this.parallelRun(), other.parallelRun());
    }

    public final String toString() {
        return ToString.builder((String)"SuiteRunConfiguration").add("PrimaryDevice", (Object)this.primaryDevice()).add("SelectedTestList", this.hasSelectedTestList() ? this.selectedTestList() : null).add("ParallelRun", (Object)this.parallelRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "primaryDevice": {
                return Optional.ofNullable(clazz.cast(this.primaryDevice()));
            }
            case "selectedTestList": {
                return Optional.ofNullable(clazz.cast(this.selectedTestList()));
            }
            case "parallelRun": {
                return Optional.ofNullable(clazz.cast(this.parallelRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("primaryDevice", PRIMARY_DEVICE_FIELD);
        map.put("selectedTestList", SELECTED_TEST_LIST_FIELD);
        map.put("parallelRun", PARALLEL_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuiteRunConfiguration, T> g) {
        return obj -> g.apply((SuiteRunConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DeviceUnderTest primaryDevice;
        private List<String> selectedTestList = DefaultSdkAutoConstructList.getInstance();
        private Boolean parallelRun;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteRunConfiguration model) {
            this.primaryDevice(model.primaryDevice);
            this.selectedTestList(model.selectedTestList);
            this.parallelRun(model.parallelRun);
        }

        public final DeviceUnderTest.Builder getPrimaryDevice() {
            return this.primaryDevice != null ? this.primaryDevice.toBuilder() : null;
        }

        public final void setPrimaryDevice(DeviceUnderTest.BuilderImpl primaryDevice) {
            this.primaryDevice = primaryDevice != null ? primaryDevice.build() : null;
        }

        @Override
        public final Builder primaryDevice(DeviceUnderTest primaryDevice) {
            this.primaryDevice = primaryDevice;
            return this;
        }

        public final Collection<String> getSelectedTestList() {
            if (this.selectedTestList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedTestList;
        }

        public final void setSelectedTestList(Collection<String> selectedTestList) {
            this.selectedTestList = SelectedTestListCopier.copy(selectedTestList);
        }

        @Override
        public final Builder selectedTestList(Collection<String> selectedTestList) {
            this.selectedTestList = SelectedTestListCopier.copy(selectedTestList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedTestList(String ... selectedTestList) {
            this.selectedTestList(Arrays.asList(selectedTestList));
            return this;
        }

        public final Boolean getParallelRun() {
            return this.parallelRun;
        }

        public final void setParallelRun(Boolean parallelRun) {
            this.parallelRun = parallelRun;
        }

        @Override
        public final Builder parallelRun(Boolean parallelRun) {
            this.parallelRun = parallelRun;
            return this;
        }

        public SuiteRunConfiguration build() {
            return new SuiteRunConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuiteRunConfiguration> {
        public Builder primaryDevice(DeviceUnderTest var1);

        default public Builder primaryDevice(Consumer<DeviceUnderTest.Builder> primaryDevice) {
            return this.primaryDevice((DeviceUnderTest)((DeviceUnderTest.Builder)DeviceUnderTest.builder().applyMutation(primaryDevice)).build());
        }

        public Builder selectedTestList(Collection<String> var1);

        public Builder selectedTestList(String ... var1);

        public Builder parallelRun(Boolean var1);
    }
}

