/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorAsyncClient;
import software.amazon.awssdk.services.iotdeviceadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse;

public class ListSuiteDefinitionsPublisher
implements SdkPublisher<ListSuiteDefinitionsResponse> {
    private final IotDeviceAdvisorAsyncClient client;
    private final ListSuiteDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSuiteDefinitionsPublisher(IotDeviceAdvisorAsyncClient client, ListSuiteDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSuiteDefinitionsPublisher(IotDeviceAdvisorAsyncClient client, ListSuiteDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSuiteDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSuiteDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSuiteDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListSuiteDefinitionsResponse> {
        private ListSuiteDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSuiteDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSuiteDefinitionsResponse> nextPage(ListSuiteDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListSuiteDefinitionsPublisher.this.client.listSuiteDefinitions(ListSuiteDefinitionsPublisher.this.firstRequest);
            }
            return ListSuiteDefinitionsPublisher.this.client.listSuiteDefinitions((ListSuiteDefinitionsRequest)((Object)ListSuiteDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

