/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthenticationMethod {
    X509_CLIENT_CERTIFICATE("X509ClientCertificate"),
    SIGNATURE_VERSION4("SignatureVersion4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthenticationMethod> VALUE_MAP;
    private final String value;

    private AuthenticationMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationMethod> knownValues() {
        EnumSet<AuthenticationMethod> knownValues = EnumSet.allOf(AuthenticationMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthenticationMethod.class, AuthenticationMethod::toString);
    }
}

