/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotdeviceadvisor.model.IotDeviceAdvisorRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSuiteRunRequest
extends IotDeviceAdvisorRequest
implements ToCopyableBuilder<Builder, StartSuiteRunRequest> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionId").getter(StartSuiteRunRequest.getter(StartSuiteRunRequest::suiteDefinitionId)).setter(StartSuiteRunRequest.setter(Builder::suiteDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("suiteDefinitionId").build()}).build();
    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionVersion").getter(StartSuiteRunRequest.getter(StartSuiteRunRequest::suiteDefinitionVersion)).setter(StartSuiteRunRequest.setter(Builder::suiteDefinitionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build()}).build();
    private static final SdkField<SuiteRunConfiguration> SUITE_RUN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("suiteRunConfiguration").getter(StartSuiteRunRequest.getter(StartSuiteRunRequest::suiteRunConfiguration)).setter(StartSuiteRunRequest.setter(Builder::suiteRunConfiguration)).constructor(SuiteRunConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartSuiteRunRequest.getter(StartSuiteRunRequest::tags)).setter(StartSuiteRunRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD, SUITE_DEFINITION_VERSION_FIELD, SUITE_RUN_CONFIGURATION_FIELD, TAGS_FIELD));
    private final String suiteDefinitionId;
    private final String suiteDefinitionVersion;
    private final SuiteRunConfiguration suiteRunConfiguration;
    private final Map<String, String> tags;

    private StartSuiteRunRequest(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.suiteRunConfiguration = builder.suiteRunConfiguration;
        this.tags = builder.tags;
    }

    public final String suiteDefinitionId() {
        return this.suiteDefinitionId;
    }

    public final String suiteDefinitionVersion() {
        return this.suiteDefinitionVersion;
    }

    public final SuiteRunConfiguration suiteRunConfiguration() {
        return this.suiteRunConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSuiteRunRequest)) {
            return false;
        }
        StartSuiteRunRequest other = (StartSuiteRunRequest)((Object)obj);
        return Objects.equals(this.suiteDefinitionId(), other.suiteDefinitionId()) && Objects.equals(this.suiteDefinitionVersion(), other.suiteDefinitionVersion()) && Objects.equals(this.suiteRunConfiguration(), other.suiteRunConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartSuiteRunRequest").add("SuiteDefinitionId", (Object)this.suiteDefinitionId()).add("SuiteDefinitionVersion", (Object)this.suiteDefinitionVersion()).add("SuiteRunConfiguration", (Object)this.suiteRunConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suiteDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionId()));
            }
            case "suiteDefinitionVersion": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionVersion()));
            }
            case "suiteRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.suiteRunConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSuiteRunRequest, T> g) {
        return obj -> g.apply((StartSuiteRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDeviceAdvisorRequest.BuilderImpl
    implements Builder {
        private String suiteDefinitionId;
        private String suiteDefinitionVersion;
        private SuiteRunConfiguration suiteRunConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSuiteRunRequest model) {
            super(model);
            this.suiteDefinitionId(model.suiteDefinitionId);
            this.suiteDefinitionVersion(model.suiteDefinitionVersion);
            this.suiteRunConfiguration(model.suiteRunConfiguration);
            this.tags(model.tags);
        }

        public final String getSuiteDefinitionId() {
            return this.suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        public final String getSuiteDefinitionVersion() {
            return this.suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        public final SuiteRunConfiguration.Builder getSuiteRunConfiguration() {
            return this.suiteRunConfiguration != null ? this.suiteRunConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder suiteRunConfiguration(SuiteRunConfiguration suiteRunConfiguration) {
            this.suiteRunConfiguration = suiteRunConfiguration;
            return this;
        }

        public final void setSuiteRunConfiguration(SuiteRunConfiguration.BuilderImpl suiteRunConfiguration) {
            this.suiteRunConfiguration = suiteRunConfiguration != null ? suiteRunConfiguration.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSuiteRunRequest build() {
            return new StartSuiteRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotDeviceAdvisorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSuiteRunRequest> {
        public Builder suiteDefinitionId(String var1);

        public Builder suiteDefinitionVersion(String var1);

        public Builder suiteRunConfiguration(SuiteRunConfiguration var1);

        default public Builder suiteRunConfiguration(Consumer<SuiteRunConfiguration.Builder> suiteRunConfiguration) {
            return this.suiteRunConfiguration((SuiteRunConfiguration)((SuiteRunConfiguration.Builder)SuiteRunConfiguration.builder().applyMutation(suiteRunConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

