/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotdeviceadvisor.model.IotDeviceAdvisorResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunConfiguration;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TagMapCopier;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSuiteRunResponse
extends IotDeviceAdvisorResponse
implements ToCopyableBuilder<Builder, GetSuiteRunResponse> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionId").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::suiteDefinitionId)).setter(GetSuiteRunResponse.setter(Builder::suiteDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()}).build();
    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionVersion").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::suiteDefinitionVersion)).setter(GetSuiteRunResponse.setter(Builder::suiteDefinitionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build()}).build();
    private static final SdkField<String> SUITE_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteRunId").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::suiteRunId)).setter(GetSuiteRunResponse.setter(Builder::suiteRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunId").build()}).build();
    private static final SdkField<String> SUITE_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteRunArn").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::suiteRunArn)).setter(GetSuiteRunResponse.setter(Builder::suiteRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunArn").build()}).build();
    private static final SdkField<SuiteRunConfiguration> SUITE_RUN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("suiteRunConfiguration").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::suiteRunConfiguration)).setter(GetSuiteRunResponse.setter(Builder::suiteRunConfiguration)).constructor(SuiteRunConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunConfiguration").build()}).build();
    private static final SdkField<TestResult> TEST_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testResult").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::testResult)).setter(GetSuiteRunResponse.setter(Builder::testResult)).constructor(TestResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testResult").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::startTime)).setter(GetSuiteRunResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::endTime)).setter(GetSuiteRunResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::statusAsString)).setter(GetSuiteRunResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorReason").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::errorReason)).setter(GetSuiteRunResponse.setter(Builder::errorReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetSuiteRunResponse.getter(GetSuiteRunResponse::tags)).setter(GetSuiteRunResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD, SUITE_DEFINITION_VERSION_FIELD, SUITE_RUN_ID_FIELD, SUITE_RUN_ARN_FIELD, SUITE_RUN_CONFIGURATION_FIELD, TEST_RESULT_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, ERROR_REASON_FIELD, TAGS_FIELD));
    private final String suiteDefinitionId;
    private final String suiteDefinitionVersion;
    private final String suiteRunId;
    private final String suiteRunArn;
    private final SuiteRunConfiguration suiteRunConfiguration;
    private final TestResult testResult;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;
    private final String errorReason;
    private final Map<String, String> tags;

    private GetSuiteRunResponse(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.suiteRunId = builder.suiteRunId;
        this.suiteRunArn = builder.suiteRunArn;
        this.suiteRunConfiguration = builder.suiteRunConfiguration;
        this.testResult = builder.testResult;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.errorReason = builder.errorReason;
        this.tags = builder.tags;
    }

    public final String suiteDefinitionId() {
        return this.suiteDefinitionId;
    }

    public final String suiteDefinitionVersion() {
        return this.suiteDefinitionVersion;
    }

    public final String suiteRunId() {
        return this.suiteRunId;
    }

    public final String suiteRunArn() {
        return this.suiteRunArn;
    }

    public final SuiteRunConfiguration suiteRunConfiguration() {
        return this.suiteRunConfiguration;
    }

    public final TestResult testResult() {
        return this.testResult;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final SuiteRunStatus status() {
        return SuiteRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String errorReason() {
        return this.errorReason;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteRunConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.testResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteRunResponse)) {
            return false;
        }
        GetSuiteRunResponse other = (GetSuiteRunResponse)((Object)obj);
        return Objects.equals(this.suiteDefinitionId(), other.suiteDefinitionId()) && Objects.equals(this.suiteDefinitionVersion(), other.suiteDefinitionVersion()) && Objects.equals(this.suiteRunId(), other.suiteRunId()) && Objects.equals(this.suiteRunArn(), other.suiteRunArn()) && Objects.equals(this.suiteRunConfiguration(), other.suiteRunConfiguration()) && Objects.equals(this.testResult(), other.testResult()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.errorReason(), other.errorReason()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetSuiteRunResponse").add("SuiteDefinitionId", (Object)this.suiteDefinitionId()).add("SuiteDefinitionVersion", (Object)this.suiteDefinitionVersion()).add("SuiteRunId", (Object)this.suiteRunId()).add("SuiteRunArn", (Object)this.suiteRunArn()).add("SuiteRunConfiguration", (Object)this.suiteRunConfiguration()).add("TestResult", (Object)this.testResult()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).add("ErrorReason", (Object)this.errorReason()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suiteDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionId()));
            }
            case "suiteDefinitionVersion": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionVersion()));
            }
            case "suiteRunId": {
                return Optional.ofNullable(clazz.cast(this.suiteRunId()));
            }
            case "suiteRunArn": {
                return Optional.ofNullable(clazz.cast(this.suiteRunArn()));
            }
            case "suiteRunConfiguration": {
                return Optional.ofNullable(clazz.cast(this.suiteRunConfiguration()));
            }
            case "testResult": {
                return Optional.ofNullable(clazz.cast(this.testResult()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "errorReason": {
                return Optional.ofNullable(clazz.cast(this.errorReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSuiteRunResponse, T> g) {
        return obj -> g.apply((GetSuiteRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDeviceAdvisorResponse.BuilderImpl
    implements Builder {
        private String suiteDefinitionId;
        private String suiteDefinitionVersion;
        private String suiteRunId;
        private String suiteRunArn;
        private SuiteRunConfiguration suiteRunConfiguration;
        private TestResult testResult;
        private Instant startTime;
        private Instant endTime;
        private String status;
        private String errorReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteRunResponse model) {
            super(model);
            this.suiteDefinitionId(model.suiteDefinitionId);
            this.suiteDefinitionVersion(model.suiteDefinitionVersion);
            this.suiteRunId(model.suiteRunId);
            this.suiteRunArn(model.suiteRunArn);
            this.suiteRunConfiguration(model.suiteRunConfiguration);
            this.testResult(model.testResult);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.errorReason(model.errorReason);
            this.tags(model.tags);
        }

        public final String getSuiteDefinitionId() {
            return this.suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        @Transient
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return this.suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        @Transient
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final String getSuiteRunId() {
            return this.suiteRunId;
        }

        public final void setSuiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
        }

        @Override
        @Transient
        public final Builder suiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
            return this;
        }

        public final String getSuiteRunArn() {
            return this.suiteRunArn;
        }

        public final void setSuiteRunArn(String suiteRunArn) {
            this.suiteRunArn = suiteRunArn;
        }

        @Override
        @Transient
        public final Builder suiteRunArn(String suiteRunArn) {
            this.suiteRunArn = suiteRunArn;
            return this;
        }

        public final SuiteRunConfiguration.Builder getSuiteRunConfiguration() {
            return this.suiteRunConfiguration != null ? this.suiteRunConfiguration.toBuilder() : null;
        }

        public final void setSuiteRunConfiguration(SuiteRunConfiguration.BuilderImpl suiteRunConfiguration) {
            this.suiteRunConfiguration = suiteRunConfiguration != null ? suiteRunConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder suiteRunConfiguration(SuiteRunConfiguration suiteRunConfiguration) {
            this.suiteRunConfiguration = suiteRunConfiguration;
            return this;
        }

        public final TestResult.Builder getTestResult() {
            return this.testResult != null ? this.testResult.toBuilder() : null;
        }

        public final void setTestResult(TestResult.BuilderImpl testResult) {
            this.testResult = testResult != null ? testResult.build() : null;
        }

        @Override
        @Transient
        public final Builder testResult(TestResult testResult) {
            this.testResult = testResult;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(SuiteRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorReason() {
            return this.errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        @Transient
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetSuiteRunResponse build() {
            return new GetSuiteRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotDeviceAdvisorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSuiteRunResponse> {
        public Builder suiteDefinitionId(String var1);

        public Builder suiteDefinitionVersion(String var1);

        public Builder suiteRunId(String var1);

        public Builder suiteRunArn(String var1);

        public Builder suiteRunConfiguration(SuiteRunConfiguration var1);

        default public Builder suiteRunConfiguration(Consumer<SuiteRunConfiguration.Builder> suiteRunConfiguration) {
            return this.suiteRunConfiguration((SuiteRunConfiguration)((SuiteRunConfiguration.Builder)SuiteRunConfiguration.builder().applyMutation(suiteRunConfiguration)).build());
        }

        public Builder testResult(TestResult var1);

        default public Builder testResult(Consumer<TestResult.Builder> testResult) {
            return this.testResult((TestResult)((TestResult.Builder)TestResult.builder().applyMutation(testResult)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder status(SuiteRunStatus var1);

        public Builder errorReason(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

