/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorAsyncClient;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListTestCasesRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListTestCasesResponse;

public class ListTestCasesPublisher
implements SdkPublisher<ListTestCasesResponse> {
    private final IotDeviceAdvisorAsyncClient client;
    private final ListTestCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestCasesPublisher(IotDeviceAdvisorAsyncClient client, ListTestCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestCasesPublisher(IotDeviceAdvisorAsyncClient client, ListTestCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestCasesResponseFetcher
    implements AsyncPageFetcher<ListTestCasesResponse> {
        private ListTestCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListTestCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestCasesResponse> nextPage(ListTestCasesResponse previousPage) {
            if (previousPage == null) {
                return ListTestCasesPublisher.this.client.listTestCases(ListTestCasesPublisher.this.firstRequest);
            }
            return ListTestCasesPublisher.this.client.listTestCases((ListTestCasesRequest)((Object)ListTestCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

