/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseDefinition;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestCase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestCase> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TestCase.getter(TestCase::name)).setter(TestCase.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("configuration").getter(TestCase.getter(TestCase::configuration)).setter(TestCase.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TestCaseDefinition> TEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("test").getter(TestCase.getter(TestCase::test)).setter(TestCase.setter(Builder::test)).constructor(TestCaseDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("test").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIGURATION_FIELD, TEST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Map<String, String> configuration;
    private final TestCaseDefinition test;

    private TestCase(BuilderImpl builder) {
        this.name = builder.name;
        this.configuration = builder.configuration;
        this.test = builder.test;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> configuration() {
        return this.configuration;
    }

    public final TestCaseDefinition test() {
        return this.test;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCase)) {
            return false;
        }
        TestCase other = (TestCase)obj;
        return Objects.equals(this.name(), other.name()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.test(), other.test());
    }

    public final String toString() {
        return ToString.builder((String)"TestCase").add("Name", (Object)this.name()).add("Configuration", this.hasConfiguration() ? this.configuration() : null).add("Test", (Object)this.test()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "test": {
                return Optional.ofNullable(clazz.cast(this.test()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCase, T> g) {
        return obj -> g.apply((TestCase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Map<String, String> configuration = DefaultSdkAutoConstructMap.getInstance();
        private TestCaseDefinition test;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCase model) {
            this.name(model.name);
            this.configuration(model.configuration);
            this.test(model.test);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configuration;
        }

        @Override
        public final Builder configuration(Map<String, String> configuration) {
            this.configuration = TestConfigurationCopier.copy(configuration);
            return this;
        }

        public final void setConfiguration(Map<String, String> configuration) {
            this.configuration = TestConfigurationCopier.copy(configuration);
        }

        public final TestCaseDefinition.Builder getTest() {
            return this.test != null ? this.test.toBuilder() : null;
        }

        @Override
        public final Builder test(TestCaseDefinition test) {
            this.test = test;
            return this;
        }

        public final void setTest(TestCaseDefinition.BuilderImpl test) {
            this.test = test != null ? test.build() : null;
        }

        public TestCase build() {
            return new TestCase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestCase> {
        public Builder name(String var1);

        public Builder configuration(Map<String, String> var1);

        public Builder test(TestCaseDefinition var1);

        default public Builder test(Consumer<TestCaseDefinition.Builder> test) {
            return this.test((TestCaseDefinition)((TestCaseDefinition.Builder)TestCaseDefinition.builder().applyMutation(test)).build());
        }
    }
}

