/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotdataplane.model.IotDataPlaneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteConnectionRequest
extends IotDataPlaneRequest
implements ToCopyableBuilder<Builder, DeleteConnectionRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(DeleteConnectionRequest.getter(DeleteConnectionRequest::clientId)).setter(DeleteConnectionRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clientId").build()}).build();
    private static final SdkField<Boolean> CLEAN_SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("cleanSession").getter(DeleteConnectionRequest.getter(DeleteConnectionRequest::cleanSession)).setter(DeleteConnectionRequest.setter(Builder::cleanSession)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("cleanSession").build()}).build();
    private static final SdkField<Boolean> PREVENT_WILL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("preventWillMessage").getter(DeleteConnectionRequest.getter(DeleteConnectionRequest::preventWillMessage)).setter(DeleteConnectionRequest.setter(Builder::preventWillMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("preventWillMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLEAN_SESSION_FIELD, PREVENT_WILL_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteConnectionRequest.memberNameToFieldInitializer();
    private final String clientId;
    private final Boolean cleanSession;
    private final Boolean preventWillMessage;

    private DeleteConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.cleanSession = builder.cleanSession;
        this.preventWillMessage = builder.preventWillMessage;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final Boolean cleanSession() {
        return this.cleanSession;
    }

    public final Boolean preventWillMessage() {
        return this.preventWillMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cleanSession());
        hashCode = 31 * hashCode + Objects.hashCode(this.preventWillMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConnectionRequest)) {
            return false;
        }
        DeleteConnectionRequest other = (DeleteConnectionRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.cleanSession(), other.cleanSession()) && Objects.equals(this.preventWillMessage(), other.preventWillMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteConnectionRequest").add("ClientId", (Object)this.clientId()).add("CleanSession", (Object)this.cleanSession()).add("PreventWillMessage", (Object)this.preventWillMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "cleanSession": {
                return Optional.ofNullable(clazz.cast(this.cleanSession()));
            }
            case "preventWillMessage": {
                return Optional.ofNullable(clazz.cast(this.preventWillMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("cleanSession", CLEAN_SESSION_FIELD);
        map.put("preventWillMessage", PREVENT_WILL_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteConnectionRequest, T> g) {
        return obj -> g.apply((DeleteConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDataPlaneRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private Boolean cleanSession;
        private Boolean preventWillMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConnectionRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.cleanSession(model.cleanSession);
            this.preventWillMessage(model.preventWillMessage);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Boolean getCleanSession() {
            return this.cleanSession;
        }

        public final void setCleanSession(Boolean cleanSession) {
            this.cleanSession = cleanSession;
        }

        @Override
        public final Builder cleanSession(Boolean cleanSession) {
            this.cleanSession = cleanSession;
            return this;
        }

        public final Boolean getPreventWillMessage() {
            return this.preventWillMessage;
        }

        public final void setPreventWillMessage(Boolean preventWillMessage) {
            this.preventWillMessage = preventWillMessage;
        }

        @Override
        public final Builder preventWillMessage(Boolean preventWillMessage) {
            this.preventWillMessage = preventWillMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConnectionRequest build() {
            return new DeleteConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotDataPlaneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteConnectionRequest> {
        public Builder clientId(String var1);

        public Builder cleanSession(Boolean var1);

        public Builder preventWillMessage(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

