/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdataplane.model.IotDataPlaneResponse;
import software.amazon.awssdk.services.iotdataplane.model.RetainedMessageListCopier;
import software.amazon.awssdk.services.iotdataplane.model.RetainedMessageSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRetainedMessagesResponse
extends IotDataPlaneResponse
implements ToCopyableBuilder<Builder, ListRetainedMessagesResponse> {
    private static final SdkField<List<RetainedMessageSummary>> RETAINED_TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("retainedTopics").getter(ListRetainedMessagesResponse.getter(ListRetainedMessagesResponse::retainedTopics)).setter(ListRetainedMessagesResponse.setter(Builder::retainedTopics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retainedTopics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetainedMessageSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRetainedMessagesResponse.getter(ListRetainedMessagesResponse::nextToken)).setter(ListRetainedMessagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETAINED_TOPICS_FIELD, NEXT_TOKEN_FIELD));
    private final List<RetainedMessageSummary> retainedTopics;
    private final String nextToken;

    private ListRetainedMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.retainedTopics = builder.retainedTopics;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRetainedTopics() {
        return this.retainedTopics != null && !(this.retainedTopics instanceof SdkAutoConstructList);
    }

    public final List<RetainedMessageSummary> retainedTopics() {
        return this.retainedTopics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetainedTopics() ? this.retainedTopics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRetainedMessagesResponse)) {
            return false;
        }
        ListRetainedMessagesResponse other = (ListRetainedMessagesResponse)((Object)obj);
        return this.hasRetainedTopics() == other.hasRetainedTopics() && Objects.equals(this.retainedTopics(), other.retainedTopics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRetainedMessagesResponse").add("RetainedTopics", this.hasRetainedTopics() ? this.retainedTopics() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "retainedTopics": {
                return Optional.ofNullable(clazz.cast(this.retainedTopics()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRetainedMessagesResponse, T> g) {
        return obj -> g.apply((ListRetainedMessagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDataPlaneResponse.BuilderImpl
    implements Builder {
        private List<RetainedMessageSummary> retainedTopics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRetainedMessagesResponse model) {
            super(model);
            this.retainedTopics(model.retainedTopics);
            this.nextToken(model.nextToken);
        }

        public final List<RetainedMessageSummary.Builder> getRetainedTopics() {
            List<RetainedMessageSummary.Builder> result = RetainedMessageListCopier.copyToBuilder(this.retainedTopics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetainedTopics(Collection<RetainedMessageSummary.BuilderImpl> retainedTopics) {
            this.retainedTopics = RetainedMessageListCopier.copyFromBuilder(retainedTopics);
        }

        @Override
        public final Builder retainedTopics(Collection<RetainedMessageSummary> retainedTopics) {
            this.retainedTopics = RetainedMessageListCopier.copy(retainedTopics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainedTopics(RetainedMessageSummary ... retainedTopics) {
            this.retainedTopics(Arrays.asList(retainedTopics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainedTopics(Consumer<RetainedMessageSummary.Builder> ... retainedTopics) {
            this.retainedTopics(Stream.of(retainedTopics).map(c -> (RetainedMessageSummary)((RetainedMessageSummary.Builder)RetainedMessageSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRetainedMessagesResponse build() {
            return new ListRetainedMessagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotDataPlaneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRetainedMessagesResponse> {
        public Builder retainedTopics(Collection<RetainedMessageSummary> var1);

        public Builder retainedTopics(RetainedMessageSummary ... var1);

        public Builder retainedTopics(Consumer<RetainedMessageSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

