/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotdataplane.DefaultIotDataPlaneAsyncClient;
import software.amazon.awssdk.services.iotdataplane.DefaultIotDataPlaneBaseClientBuilder;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneAsyncClient;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneAsyncClientBuilder;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneServiceClientConfiguration;
import software.amazon.awssdk.services.iotdataplane.endpoints.IotDataPlaneEndpointProvider;

@SdkInternalApi
final class DefaultIotDataPlaneAsyncClientBuilder
extends DefaultIotDataPlaneBaseClientBuilder<IotDataPlaneAsyncClientBuilder, IotDataPlaneAsyncClient>
implements IotDataPlaneAsyncClientBuilder {
    DefaultIotDataPlaneAsyncClientBuilder() {
    }

    @Override
    public DefaultIotDataPlaneAsyncClientBuilder endpointProvider(IotDataPlaneEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotDataPlaneAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIotDataPlaneAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IotDataPlaneServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotDataPlaneAsyncClient client = new DefaultIotDataPlaneAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotDataPlaneServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotDataPlaneServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

