/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotdataplane.DefaultIotDataPlaneBaseClientBuilder;
import software.amazon.awssdk.services.iotdataplane.DefaultIotDataPlaneClient;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneClient;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneClientBuilder;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneServiceClientConfiguration;
import software.amazon.awssdk.services.iotdataplane.endpoints.IotDataPlaneEndpointProvider;

@SdkInternalApi
final class DefaultIotDataPlaneClientBuilder
extends DefaultIotDataPlaneBaseClientBuilder<IotDataPlaneClientBuilder, IotDataPlaneClient>
implements IotDataPlaneClientBuilder {
    DefaultIotDataPlaneClientBuilder() {
    }

    @Override
    public DefaultIotDataPlaneClientBuilder endpointProvider(IotDataPlaneEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotDataPlaneClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIotDataPlaneClientBuilder.validateClientOptions(clientConfiguration);
        IotDataPlaneServiceClientConfiguration serviceClientConfiguration = IotDataPlaneServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultIotDataPlaneClient(serviceClientConfiguration, clientConfiguration);
    }
}

