/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneClient;
import software.amazon.awssdk.services.iotdataplane.model.ListRetainedMessagesRequest;
import software.amazon.awssdk.services.iotdataplane.model.ListRetainedMessagesResponse;
import software.amazon.awssdk.services.iotdataplane.model.RetainedMessageSummary;

public class ListRetainedMessagesIterable
implements SdkIterable<ListRetainedMessagesResponse> {
    private final IotDataPlaneClient client;
    private final ListRetainedMessagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRetainedMessagesIterable(IotDataPlaneClient client, ListRetainedMessagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRetainedMessagesResponseFetcher();
    }

    public Iterator<ListRetainedMessagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RetainedMessageSummary> retainedTopics() {
        Function<ListRetainedMessagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.retainedTopics() != null) {
                return response.retainedTopics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRetainedMessagesResponseFetcher
    implements SyncPageFetcher<ListRetainedMessagesResponse> {
        private ListRetainedMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListRetainedMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRetainedMessagesResponse nextPage(ListRetainedMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListRetainedMessagesIterable.this.client.listRetainedMessages(ListRetainedMessagesIterable.this.firstRequest);
            }
            return ListRetainedMessagesIterable.this.client.listRetainedMessages((ListRetainedMessagesRequest)((Object)ListRetainedMessagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

