/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetainedMessageSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetainedMessageSummary> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("topic").getter(RetainedMessageSummary.getter(RetainedMessageSummary::topic)).setter(RetainedMessageSummary.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()}).build();
    private static final SdkField<Long> PAYLOAD_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("payloadSize").getter(RetainedMessageSummary.getter(RetainedMessageSummary::payloadSize)).setter(RetainedMessageSummary.setter(Builder::payloadSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadSize").build()}).build();
    private static final SdkField<Integer> QOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("qos").getter(RetainedMessageSummary.getter(RetainedMessageSummary::qos)).setter(RetainedMessageSummary.setter(Builder::qos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qos").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTime").getter(RetainedMessageSummary.getter(RetainedMessageSummary::lastModifiedTime)).setter(RetainedMessageSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, PAYLOAD_SIZE_FIELD, QOS_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String topic;
    private final Long payloadSize;
    private final Integer qos;
    private final Long lastModifiedTime;

    private RetainedMessageSummary(BuilderImpl builder) {
        this.topic = builder.topic;
        this.payloadSize = builder.payloadSize;
        this.qos = builder.qos;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String topic() {
        return this.topic;
    }

    public final Long payloadSize() {
        return this.payloadSize;
    }

    public final Integer qos() {
        return this.qos;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.qos());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetainedMessageSummary)) {
            return false;
        }
        RetainedMessageSummary other = (RetainedMessageSummary)obj;
        return Objects.equals(this.topic(), other.topic()) && Objects.equals(this.payloadSize(), other.payloadSize()) && Objects.equals(this.qos(), other.qos()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"RetainedMessageSummary").add("Topic", (Object)this.topic()).add("PayloadSize", (Object)this.payloadSize()).add("Qos", (Object)this.qos()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "payloadSize": {
                return Optional.ofNullable(clazz.cast(this.payloadSize()));
            }
            case "qos": {
                return Optional.ofNullable(clazz.cast(this.qos()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetainedMessageSummary, T> g) {
        return obj -> g.apply((RetainedMessageSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topic;
        private Long payloadSize;
        private Integer qos;
        private Long lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RetainedMessageSummary model) {
            this.topic(model.topic);
            this.payloadSize(model.payloadSize);
            this.qos(model.qos);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getTopic() {
            return this.topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        @Transient
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final Long getPayloadSize() {
            return this.payloadSize;
        }

        public final void setPayloadSize(Long payloadSize) {
            this.payloadSize = payloadSize;
        }

        @Override
        @Transient
        public final Builder payloadSize(Long payloadSize) {
            this.payloadSize = payloadSize;
            return this;
        }

        public final Integer getQos() {
            return this.qos;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        @Override
        @Transient
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public RetainedMessageSummary build() {
            return new RetainedMessageSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetainedMessageSummary> {
        public Builder topic(String var1);

        public Builder payloadSize(Long var1);

        public Builder qos(Integer var1);

        public Builder lastModifiedTime(Long var1);
    }
}

