/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LambdaActivity.getter(LambdaActivity::name)).setter(LambdaActivity.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LAMBDA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaName").getter(LambdaActivity.getter(LambdaActivity::lambdaName)).setter(LambdaActivity.setter(Builder::lambdaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaName").build()}).build();
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("batchSize").getter(LambdaActivity.getter(LambdaActivity::batchSize)).setter(LambdaActivity.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchSize").build()}).build();
    private static final SdkField<String> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("next").getter(LambdaActivity.getter(LambdaActivity::next)).setter(LambdaActivity.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LAMBDA_NAME_FIELD, BATCH_SIZE_FIELD, NEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LambdaActivity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String lambdaName;
    private final Integer batchSize;
    private final String next;

    private LambdaActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.lambdaName = builder.lambdaName;
        this.batchSize = builder.batchSize;
        this.next = builder.next;
    }

    public final String name() {
        return this.name;
    }

    public final String lambdaName() {
        return this.lambdaName;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final String next() {
        return this.next;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.next());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaActivity)) {
            return false;
        }
        LambdaActivity other = (LambdaActivity)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.lambdaName(), other.lambdaName()) && Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.next(), other.next());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaActivity").add("Name", (Object)this.name()).add("LambdaName", (Object)this.lambdaName()).add("BatchSize", (Object)this.batchSize()).add("Next", (Object)this.next()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "lambdaName": {
                return Optional.ofNullable(clazz.cast(this.lambdaName()));
            }
            case "batchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("lambdaName", LAMBDA_NAME_FIELD);
        map.put("batchSize", BATCH_SIZE_FIELD);
        map.put("next", NEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaActivity, T> g) {
        return obj -> g.apply((LambdaActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String lambdaName;
        private Integer batchSize;
        private String next;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaActivity model) {
            this.name(model.name);
            this.lambdaName(model.lambdaName);
            this.batchSize(model.batchSize);
            this.next(model.next);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLambdaName() {
            return this.lambdaName;
        }

        public final void setLambdaName(String lambdaName) {
            this.lambdaName = lambdaName;
        }

        @Override
        public final Builder lambdaName(String lambdaName) {
            this.lambdaName = lambdaName;
            return this;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final String getNext() {
            return this.next;
        }

        public final void setNext(String next) {
            this.next = next;
        }

        @Override
        public final Builder next(String next) {
            this.next = next;
            return this;
        }

        public LambdaActivity build() {
            return new LambdaActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaActivity> {
        public Builder name(String var1);

        public Builder lambdaName(String var1);

        public Builder batchSize(Integer var1);

        public Builder next(String var1);
    }
}

