/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SQL query to modify the message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlQueryDatasetAction implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlQueryDatasetAction.Builder, SqlQueryDatasetAction> {
    private static final SdkField<String> SQL_QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sqlQuery").getter(getter(SqlQueryDatasetAction::sqlQuery)).setter(setter(Builder::sqlQuery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlQuery").build()).build();

    private static final SdkField<List<QueryFilter>> FILTERS_FIELD = SdkField
            .<List<QueryFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(SqlQueryDatasetAction::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SQL_QUERY_FIELD, FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sqlQuery;

    private final List<QueryFilter> filters;

    private SqlQueryDatasetAction(BuilderImpl builder) {
        this.sqlQuery = builder.sqlQuery;
        this.filters = builder.filters;
    }

    /**
     * <p>
     * A SQL query string.
     * </p>
     * 
     * @return A SQL query string.
     */
    public final String sqlQuery() {
        return sqlQuery;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Prefilters applied to message data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Prefilters applied to message data.
     */
    public final List<QueryFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlQueryDatasetAction)) {
            return false;
        }
        SqlQueryDatasetAction other = (SqlQueryDatasetAction) obj;
        return Objects.equals(sqlQuery(), other.sqlQuery()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqlQueryDatasetAction").add("SqlQuery", sqlQuery())
                .add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sqlQuery":
            return Optional.ofNullable(clazz.cast(sqlQuery()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sqlQuery", SQL_QUERY_FIELD);
        map.put("filters", FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SqlQueryDatasetAction, T> g) {
        return obj -> g.apply((SqlQueryDatasetAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlQueryDatasetAction> {
        /**
         * <p>
         * A SQL query string.
         * </p>
         * 
         * @param sqlQuery
         *        A SQL query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlQuery(String sqlQuery);

        /**
         * <p>
         * Prefilters applied to message data.
         * </p>
         * 
         * @param filters
         *        Prefilters applied to message data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<QueryFilter> filters);

        /**
         * <p>
         * Prefilters applied to message data.
         * </p>
         * 
         * @param filters
         *        Prefilters applied to message data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(QueryFilter... filters);

        /**
         * <p>
         * Prefilters applied to message data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotanalytics.model.QueryFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotanalytics.model.QueryFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotanalytics.model.QueryFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<QueryFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotanalytics.model.QueryFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<QueryFilter>)
         */
        Builder filters(Consumer<QueryFilter.Builder>... filters);
    }

    static final class BuilderImpl implements Builder {
        private String sqlQuery;

        private List<QueryFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SqlQueryDatasetAction model) {
            sqlQuery(model.sqlQuery);
            filters(model.filters);
        }

        public final String getSqlQuery() {
            return sqlQuery;
        }

        public final void setSqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
        }

        @Override
        public final Builder sqlQuery(String sqlQuery) {
            this.sqlQuery = sqlQuery;
            return this;
        }

        public final List<QueryFilter.Builder> getFilters() {
            List<QueryFilter.Builder> result = QueryFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<QueryFilter.BuilderImpl> filters) {
            this.filters = QueryFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<QueryFilter> filters) {
            this.filters = QueryFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(QueryFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<QueryFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> QueryFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SqlQueryDatasetAction build() {
            return new SqlQueryDatasetAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
