/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SampleChannelDataResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<SampleChannelDataResponse.Builder, SampleChannelDataResponse> {
    private static final SdkField<List<SdkBytes>> PAYLOADS_FIELD = SdkField
            .<List<SdkBytes>> builder(MarshallingType.LIST)
            .memberName("payloads")
            .getter(getter(SampleChannelDataResponse::payloads))
            .setter(setter(Builder::payloads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloads").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOADS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SdkBytes> payloads;

    private SampleChannelDataResponse(BuilderImpl builder) {
        super(builder);
        this.payloads = builder.payloads;
    }

    /**
     * For responses, this returns true if the service returned a value for the Payloads property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPayloads() {
        return payloads != null && !(payloads instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of message samples. Each sample message is returned as a base64-encoded string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPayloads} method.
     * </p>
     * 
     * @return The list of message samples. Each sample message is returned as a base64-encoded string.
     */
    public final List<SdkBytes> payloads() {
        return payloads;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPayloads() ? payloads() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SampleChannelDataResponse)) {
            return false;
        }
        SampleChannelDataResponse other = (SampleChannelDataResponse) obj;
        return hasPayloads() == other.hasPayloads() && Objects.equals(payloads(), other.payloads());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SampleChannelDataResponse").add("Payloads", hasPayloads() ? payloads() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "payloads":
            return Optional.ofNullable(clazz.cast(payloads()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("payloads", PAYLOADS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SampleChannelDataResponse, T> g) {
        return obj -> g.apply((SampleChannelDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, SampleChannelDataResponse> {
        /**
         * <p>
         * The list of message samples. Each sample message is returned as a base64-encoded string.
         * </p>
         * 
         * @param payloads
         *        The list of message samples. Each sample message is returned as a base64-encoded string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloads(Collection<SdkBytes> payloads);

        /**
         * <p>
         * The list of message samples. Each sample message is returned as a base64-encoded string.
         * </p>
         * 
         * @param payloads
         *        The list of message samples. Each sample message is returned as a base64-encoded string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloads(SdkBytes... payloads);
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private List<SdkBytes> payloads = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SampleChannelDataResponse model) {
            super(model);
            payloads(model.payloads);
        }

        public final List<ByteBuffer> getPayloads() {
            if (payloads instanceof SdkAutoConstructList) {
                return null;
            }
            return payloads == null ? null : payloads.stream().map(SdkBytes::asByteBuffer).collect(Collectors.toList());
        }

        public final void setPayloads(Collection<ByteBuffer> payloads) {
            payloads(payloads == null ? null : payloads.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        @Override
        public final Builder payloads(Collection<SdkBytes> payloads) {
            this.payloads = MessagePayloadsCopier.copy(payloads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payloads(SdkBytes... payloads) {
            payloads(Arrays.asList(payloads));
            return this;
        }

        @Override
        public SampleChannelDataResponse build() {
            return new SampleChannelDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
