/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The estimated size of the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EstimatedResourceSize implements SdkPojo, Serializable,
        ToCopyableBuilder<EstimatedResourceSize.Builder, EstimatedResourceSize> {
    private static final SdkField<Double> ESTIMATED_SIZE_IN_BYTES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("estimatedSizeInBytes").getter(getter(EstimatedResourceSize::estimatedSizeInBytes))
            .setter(setter(Builder::estimatedSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedSizeInBytes").build())
            .build();

    private static final SdkField<Instant> ESTIMATED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("estimatedOn").getter(getter(EstimatedResourceSize::estimatedOn)).setter(setter(Builder::estimatedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_SIZE_IN_BYTES_FIELD,
            ESTIMATED_ON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double estimatedSizeInBytes;

    private final Instant estimatedOn;

    private EstimatedResourceSize(BuilderImpl builder) {
        this.estimatedSizeInBytes = builder.estimatedSizeInBytes;
        this.estimatedOn = builder.estimatedOn;
    }

    /**
     * <p>
     * The estimated size of the resource, in bytes.
     * </p>
     * 
     * @return The estimated size of the resource, in bytes.
     */
    public final Double estimatedSizeInBytes() {
        return estimatedSizeInBytes;
    }

    /**
     * <p>
     * The time when the estimate of the size of the resource was made.
     * </p>
     * 
     * @return The time when the estimate of the size of the resource was made.
     */
    public final Instant estimatedOn() {
        return estimatedOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EstimatedResourceSize)) {
            return false;
        }
        EstimatedResourceSize other = (EstimatedResourceSize) obj;
        return Objects.equals(estimatedSizeInBytes(), other.estimatedSizeInBytes())
                && Objects.equals(estimatedOn(), other.estimatedOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EstimatedResourceSize").add("EstimatedSizeInBytes", estimatedSizeInBytes())
                .add("EstimatedOn", estimatedOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedSizeInBytes":
            return Optional.ofNullable(clazz.cast(estimatedSizeInBytes()));
        case "estimatedOn":
            return Optional.ofNullable(clazz.cast(estimatedOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("estimatedSizeInBytes", ESTIMATED_SIZE_IN_BYTES_FIELD);
        map.put("estimatedOn", ESTIMATED_ON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EstimatedResourceSize, T> g) {
        return obj -> g.apply((EstimatedResourceSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EstimatedResourceSize> {
        /**
         * <p>
         * The estimated size of the resource, in bytes.
         * </p>
         * 
         * @param estimatedSizeInBytes
         *        The estimated size of the resource, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSizeInBytes(Double estimatedSizeInBytes);

        /**
         * <p>
         * The time when the estimate of the size of the resource was made.
         * </p>
         * 
         * @param estimatedOn
         *        The time when the estimate of the size of the resource was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOn(Instant estimatedOn);
    }

    static final class BuilderImpl implements Builder {
        private Double estimatedSizeInBytes;

        private Instant estimatedOn;

        private BuilderImpl() {
        }

        private BuilderImpl(EstimatedResourceSize model) {
            estimatedSizeInBytes(model.estimatedSizeInBytes);
            estimatedOn(model.estimatedOn);
        }

        public final Double getEstimatedSizeInBytes() {
            return estimatedSizeInBytes;
        }

        public final void setEstimatedSizeInBytes(Double estimatedSizeInBytes) {
            this.estimatedSizeInBytes = estimatedSizeInBytes;
        }

        @Override
        public final Builder estimatedSizeInBytes(Double estimatedSizeInBytes) {
            this.estimatedSizeInBytes = estimatedSizeInBytes;
            return this;
        }

        public final Instant getEstimatedOn() {
            return estimatedOn;
        }

        public final void setEstimatedOn(Instant estimatedOn) {
            this.estimatedOn = estimatedOn;
        }

        @Override
        public final Builder estimatedOn(Instant estimatedOn) {
            this.estimatedOn = estimatedOn;
            return this;
        }

        @Override
        public EstimatedResourceSize build() {
            return new EstimatedResourceSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
