/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activity that adds data from the IoT device registry to your message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceRegistryEnrichActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceRegistryEnrichActivity.Builder, DeviceRegistryEnrichActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeviceRegistryEnrichActivity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attribute").getter(getter(DeviceRegistryEnrichActivity::attribute)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(DeviceRegistryEnrichActivity::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(DeviceRegistryEnrichActivity::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> NEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("next")
            .getter(getter(DeviceRegistryEnrichActivity::next)).setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTE_FIELD,
            THING_NAME_FIELD, ROLE_ARN_FIELD, NEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String attribute;

    private final String thingName;

    private final String roleArn;

    private final String next;

    private DeviceRegistryEnrichActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.attribute = builder.attribute;
        this.thingName = builder.thingName;
        this.roleArn = builder.roleArn;
        this.next = builder.next;
    }

    /**
     * <p>
     * The name of the <code>deviceRegistryEnrich</code> activity.
     * </p>
     * 
     * @return The name of the <code>deviceRegistryEnrich</code> activity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the attribute that is added to the message.
     * </p>
     * 
     * @return The name of the attribute that is added to the message.
     */
    public final String attribute() {
        return attribute;
    }

    /**
     * <p>
     * The name of the IoT device whose registry information is added to the message.
     * </p>
     * 
     * @return The name of the IoT device whose registry information is added to the message.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ARN of the role that allows access to the device's registry information.
     * </p>
     * 
     * @return The ARN of the role that allows access to the device's registry information.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The next activity in the pipeline.
     * </p>
     * 
     * @return The next activity in the pipeline.
     */
    public final String next() {
        return next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(next());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceRegistryEnrichActivity)) {
            return false;
        }
        DeviceRegistryEnrichActivity other = (DeviceRegistryEnrichActivity) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(attribute(), other.attribute())
                && Objects.equals(thingName(), other.thingName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(next(), other.next());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceRegistryEnrichActivity").add("Name", name()).add("Attribute", attribute())
                .add("ThingName", thingName()).add("RoleArn", roleArn()).add("Next", next()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("attribute", ATTRIBUTE_FIELD);
        map.put("thingName", THING_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("next", NEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceRegistryEnrichActivity, T> g) {
        return obj -> g.apply((DeviceRegistryEnrichActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceRegistryEnrichActivity> {
        /**
         * <p>
         * The name of the <code>deviceRegistryEnrich</code> activity.
         * </p>
         * 
         * @param name
         *        The name of the <code>deviceRegistryEnrich</code> activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the attribute that is added to the message.
         * </p>
         * 
         * @param attribute
         *        The name of the attribute that is added to the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The name of the IoT device whose registry information is added to the message.
         * </p>
         * 
         * @param thingName
         *        The name of the IoT device whose registry information is added to the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ARN of the role that allows access to the device's registry information.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that allows access to the device's registry information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The next activity in the pipeline.
         * </p>
         * 
         * @param next
         *        The next activity in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String next);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String attribute;

        private String thingName;

        private String roleArn;

        private String next;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceRegistryEnrichActivity model) {
            name(model.name);
            attribute(model.attribute);
            thingName(model.thingName);
            roleArn(model.roleArn);
            next(model.next);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getNext() {
            return next;
        }

        public final void setNext(String next) {
            this.next = next;
        }

        @Override
        public final Builder next(String next) {
            this.next = next;
            return this;
        }

        @Override
        public DeviceRegistryEnrichActivity build() {
            return new DeviceRegistryEnrichActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
