/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatastoreRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<DescribeDatastoreRequest.Builder, DescribeDatastoreRequest> {
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datastoreName").getter(getter(DescribeDatastoreRequest::datastoreName))
            .setter(setter(Builder::datastoreName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datastoreName").build()).build();

    private static final SdkField<Boolean> INCLUDE_STATISTICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeStatistics").getter(getter(DescribeDatastoreRequest::includeStatistics))
            .setter(setter(Builder::includeStatistics))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeStatistics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_NAME_FIELD,
            INCLUDE_STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datastoreName;

    private final Boolean includeStatistics;

    private DescribeDatastoreRequest(BuilderImpl builder) {
        super(builder);
        this.datastoreName = builder.datastoreName;
        this.includeStatistics = builder.includeStatistics;
    }

    /**
     * <p>
     * The name of the data store
     * </p>
     * 
     * @return The name of the data store
     */
    public final String datastoreName() {
        return datastoreName;
    }

    /**
     * <p>
     * If true, additional statistical information about the data store is included in the response. This feature can't
     * be used with a data store whose S3 storage is customer-managed.
     * </p>
     * 
     * @return If true, additional statistical information about the data store is included in the response. This
     *         feature can't be used with a data store whose S3 storage is customer-managed.
     */
    public final Boolean includeStatistics() {
        return includeStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datastoreName());
        hashCode = 31 * hashCode + Objects.hashCode(includeStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatastoreRequest)) {
            return false;
        }
        DescribeDatastoreRequest other = (DescribeDatastoreRequest) obj;
        return Objects.equals(datastoreName(), other.datastoreName())
                && Objects.equals(includeStatistics(), other.includeStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatastoreRequest").add("DatastoreName", datastoreName())
                .add("IncludeStatistics", includeStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datastoreName":
            return Optional.ofNullable(clazz.cast(datastoreName()));
        case "includeStatistics":
            return Optional.ofNullable(clazz.cast(includeStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datastoreName", DATASTORE_NAME_FIELD);
        map.put("includeStatistics", INCLUDE_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatastoreRequest, T> g) {
        return obj -> g.apply((DescribeDatastoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatastoreRequest> {
        /**
         * <p>
         * The name of the data store
         * </p>
         * 
         * @param datastoreName
         *        The name of the data store
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastoreName(String datastoreName);

        /**
         * <p>
         * If true, additional statistical information about the data store is included in the response. This feature
         * can't be used with a data store whose S3 storage is customer-managed.
         * </p>
         * 
         * @param includeStatistics
         *        If true, additional statistical information about the data store is included in the response. This
         *        feature can't be used with a data store whose S3 storage is customer-managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeStatistics(Boolean includeStatistics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String datastoreName;

        private Boolean includeStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatastoreRequest model) {
            super(model);
            datastoreName(model.datastoreName);
            includeStatistics(model.includeStatistics);
        }

        public final String getDatastoreName() {
            return datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public final Boolean getIncludeStatistics() {
            return includeStatistics;
        }

        public final void setIncludeStatistics(Boolean includeStatistics) {
            this.includeStatistics = includeStatistics;
        }

        @Override
        public final Builder includeStatistics(Boolean includeStatistics) {
            this.includeStatistics = includeStatistics;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDatastoreRequest build() {
            return new DescribeDatastoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
